/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing;

import java.util.concurrent.TimeUnit;
import oadd.org.apache.drill.exec.testing.ControlsInjector;
import oadd.org.apache.drill.exec.testing.CountDownLatchInjection;
import oadd.org.apache.drill.exec.testing.ExceptionInjection;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import oadd.org.apache.drill.exec.testing.PauseInjection;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;

public class ExecutionControlsInjector
implements ControlsInjector {
    private final Class<?> clazz;

    protected ExecutionControlsInjector(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<?> getSiteClass() {
        return this.clazz;
    }

    @Override
    public void injectUnchecked(ExecutionControls executionControls, String desc) {
        Preconditions.checkNotNull(executionControls);
        ExceptionInjection exceptionInjection = executionControls.lookupExceptionInjection(this, desc);
        if (exceptionInjection != null) {
            exceptionInjection.throwUnchecked();
        }
    }

    @Override
    public <T extends Throwable> void injectChecked(ExecutionControls executionControls, String desc, Class<T> exceptionClass) throws T {
        Preconditions.checkNotNull(executionControls);
        ExceptionInjection exceptionInjection = executionControls.lookupExceptionInjection(this, desc);
        if (exceptionInjection != null) {
            exceptionInjection.throwChecked(exceptionClass);
        }
    }

    @Override
    public void injectPause(ExecutionControls executionControls, String desc, Logger logger) {
        Preconditions.checkNotNull(executionControls);
        PauseInjection pauseInjection = executionControls.lookupPauseInjection(this, desc);
        if (pauseInjection != null) {
            long pauseDuration = pauseInjection.getMsPause();
            if (pauseDuration > 0L) {
                logger.debug("Pausing at {} for {} sec", (Object)desc, (Object)TimeUnit.MILLISECONDS.toSeconds(pauseDuration));
            } else {
                logger.debug("Pausing at {}", (Object)desc);
            }
            pauseInjection.pause();
            logger.debug("Resuming at {}", (Object)desc);
        }
    }

    @Override
    public void injectInterruptiblePause(ExecutionControls executionControls, String desc, Logger logger) throws InterruptedException {
        Preconditions.checkNotNull(executionControls);
        PauseInjection pauseInjection = executionControls.lookupPauseInjection(this, desc);
        if (pauseInjection != null) {
            logger.debug("Interruptible pausing at {}", (Object)desc);
            try {
                pauseInjection.interruptiblePause();
            }
            catch (InterruptedException e) {
                logger.debug("Pause interrupted at {}", (Object)desc);
                throw e;
            }
            logger.debug("Interruptible pause resuming at {}", (Object)desc);
        }
    }

    @Override
    public CountDownLatchInjection getLatch(ExecutionControls executionControls, String desc) {
        Preconditions.checkNotNull(executionControls);
        return executionControls.lookupCountDownLatchInjection(this, desc);
    }
}

