/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.Collection;
import oadd.org.apache.calcite.plan.RelOptTable;
import oadd.org.apache.calcite.rex.RexLiteral;
import oadd.org.apache.calcite.rex.RexNode;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.planner.logical.DrillTable;
import oadd.org.apache.drill.exec.planner.logical.DrillTranslatableTable;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Predicate;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;

public class Utilities {
    public static final String COL_NULL_ERROR = "Columns cannot be null. Use star column to select all fields.";

    public static String getFileNameForQueryFragment(FragmentContext context, String location, String tag) {
        ExecProtos.FragmentHandle handle = context.getHandle();
        String qid = QueryIdHelper.getQueryId(handle.getQueryId());
        int majorFragmentId = handle.getMajorFragmentId();
        int minorFragmentId = handle.getMinorFragmentId();
        String fileName = String.format("%s//%s_%s_%s_%s", location, qid, majorFragmentId, minorFragmentId, tag);
        return fileName;
    }

    public static BitControl.QueryContextInformation createQueryContextInfo(String defaultSchemaName, String sessionId) {
        long queryStartTime = System.currentTimeMillis();
        int timeZone = DateUtility.getIndex((String)System.getProperty("user.timezone"));
        return BitControl.QueryContextInformation.newBuilder().setDefaultSchemaName(defaultSchemaName).setQueryStartTime(queryStartTime).setTimeZone(timeZone).setSessionId(sessionId).build();
    }

    public static String getDrillVersion() {
        String v = Utilities.class.getPackage().getImplementationVersion();
        return v;
    }

    public static boolean isStarQuery(Collection<SchemaPath> projected) {
        return Iterables.tryFind((Iterable)Preconditions.checkNotNull(projected, COL_NULL_ERROR), new Predicate<SchemaPath>(){

            @Override
            public boolean apply(SchemaPath path) {
                return Preconditions.checkNotNull(path).equals(SchemaPath.STAR_COLUMN);
            }
        }).isPresent();
    }

    public static DrillTable getDrillTable(RelOptTable table) {
        DrillTable drillTable = (DrillTable)table.unwrap(DrillTable.class);
        if (drillTable == null) {
            drillTable = ((DrillTranslatableTable)table.unwrap(DrillTranslatableTable.class)).getDrillTable();
        }
        return drillTable;
    }

    public static PathSegment convertLiteral(RexLiteral literal) {
        switch (literal.getType().getSqlTypeName()) {
            case CHAR: {
                return new PathSegment.NameSegment(RexLiteral.stringValue((RexNode)literal));
            }
            case INTEGER: {
                return new PathSegment.ArraySegment(RexLiteral.intValue((RexNode)literal));
            }
        }
        return null;
    }
}

