/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedBigIntHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.BigIntVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedBigIntReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedBigIntVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private BigIntVector values;
    private final FieldReader reader = new RepeatedBigIntReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedBigIntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withScaleAndPrecision(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getScale(), majorType.getPrecision())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public BigIntVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedBigIntVector)to);
    }

    public AddOrGetResult<BigIntVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<BigIntVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedBigIntVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedBigIntVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedBigIntVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedBigIntVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedBigIntVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, long value) {
            int nextOffset = RepeatedBigIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedBigIntVector.this.values.getMutator().set(nextOffset, value);
            RepeatedBigIntVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, long srcValue) {
            int nextOffset = RepeatedBigIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedBigIntVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedBigIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedBigIntHolder h) {
            BigIntHolder ih = new BigIntHolder();
            BigIntVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedBigIntVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedBigIntVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, BigIntHolder holder) {
            int nextOffset = RepeatedBigIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedBigIntVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedBigIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableBigIntHolder holder) {
            int nextOffset = RepeatedBigIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedBigIntVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedBigIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedBigIntVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedBigIntVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, BigIntHolder holder) {
            int nextOffset = RepeatedBigIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedBigIntVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedBigIntVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedBigIntHolder holder) {
            BigIntVector.Accessor accessor = holder.vector.getAccessor();
            BigIntHolder innerHolder = new BigIntHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedBigIntVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedBigIntVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<Long> getObject(int index) {
            JsonStringArrayList<Long> vals = new JsonStringArrayList<Long>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedBigIntVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            BigIntVector.Accessor valuesAccessor = RepeatedBigIntVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Long getSingleObject(int index, int arrayIndex) {
            int start = RepeatedBigIntVector.this.offsets.getAccessor().get(index);
            return RepeatedBigIntVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public long get(int index, int positionIndex) {
            return RepeatedBigIntVector.this.values.getAccessor().get(RepeatedBigIntVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedBigIntHolder holder) {
            holder.start = RepeatedBigIntVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedBigIntVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedBigIntVector.this.values;
            holder.reader = RepeatedBigIntVector.this.reader;
        }

        public void get(int index, int positionIndex, BigIntHolder holder) {
            int offset = RepeatedBigIntVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedBigIntVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableBigIntHolder holder) {
            int offset = RepeatedBigIntVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedBigIntVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedBigIntVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedBigIntVector(field, allocator);
        }

        public TransferImpl(RepeatedBigIntVector to) {
            this.to = to;
        }

        @Override
        public RepeatedBigIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedBigIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedBigIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedBigIntVector.this);
        }
    }
}

