/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.IntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntervalYearHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.IntervalYearVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedIntervalYearReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;

public final class RepeatedIntervalYearVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private IntervalYearVector values;
    private final FieldReader reader = new RepeatedIntervalYearReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedIntervalYearVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withScaleAndPrecision(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getScale(), majorType.getPrecision())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public IntervalYearVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedIntervalYearVector)to);
    }

    public AddOrGetResult<IntervalYearVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<IntervalYearVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedIntervalYearVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedIntervalYearVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedIntervalYearVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedIntervalYearVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedIntervalYearVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalYearVector.this.values.getMutator().set(nextOffset, value);
            RepeatedIntervalYearVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, int srcValue) {
            int nextOffset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalYearVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedIntervalYearVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedIntervalYearHolder h) {
            IntervalYearHolder ih = new IntervalYearHolder();
            IntervalYearVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedIntervalYearVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedIntervalYearVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, IntervalYearHolder holder) {
            int nextOffset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalYearVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntervalYearVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableIntervalYearHolder holder) {
            int nextOffset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalYearVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedIntervalYearVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedIntervalYearVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, IntervalYearHolder holder) {
            int nextOffset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index + 1);
            RepeatedIntervalYearVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedIntervalYearVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedIntervalYearHolder holder) {
            IntervalYearVector.Accessor accessor = holder.vector.getAccessor();
            IntervalYearHolder innerHolder = new IntervalYearHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedIntervalYearVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedIntervalYearVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<Period> getObject(int index) {
            JsonStringArrayList<Period> vals = new JsonStringArrayList<Period>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedIntervalYearVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            IntervalYearVector.Accessor valuesAccessor = RepeatedIntervalYearVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Period getSingleObject(int index, int arrayIndex) {
            int start = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index);
            return RepeatedIntervalYearVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public int get(int index, int positionIndex) {
            return RepeatedIntervalYearVector.this.values.getAccessor().get(RepeatedIntervalYearVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedIntervalYearHolder holder) {
            holder.start = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedIntervalYearVector.this.values;
            holder.reader = RepeatedIntervalYearVector.this.reader;
        }

        public void get(int index, int positionIndex, IntervalYearHolder holder) {
            int offset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedIntervalYearVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableIntervalYearHolder holder) {
            int offset = RepeatedIntervalYearVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedIntervalYearVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedIntervalYearVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedIntervalYearVector(field, allocator);
        }

        public TransferImpl(RepeatedIntervalYearVector to) {
            this.to = to;
        }

        @Override
        public RepeatedIntervalYearVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedIntervalYearVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedIntervalYearVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedIntervalYearVector.this);
        }
    }
}

