/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedUInt8Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt8Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.UInt8Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedUInt8ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedUInt8Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private UInt8Vector values;
    private final FieldReader reader = new RepeatedUInt8ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedUInt8Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withScaleAndPrecision(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getScale(), majorType.getPrecision())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public UInt8Vector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedUInt8Vector)to);
    }

    public AddOrGetResult<UInt8Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<UInt8Vector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedUInt8Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedUInt8Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedUInt8Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedUInt8Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedUInt8Vector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, long value) {
            int nextOffset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt8Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedUInt8Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, long srcValue) {
            int nextOffset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt8Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedUInt8Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedUInt8Holder h) {
            UInt8Holder ih = new UInt8Holder();
            UInt8Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedUInt8Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedUInt8Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, UInt8Holder holder) {
            int nextOffset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt8Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedUInt8Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableUInt8Holder holder) {
            int nextOffset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt8Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedUInt8Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedUInt8Vector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedUInt8Vector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, UInt8Holder holder) {
            int nextOffset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt8Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedUInt8Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedUInt8Holder holder) {
            UInt8Vector.Accessor accessor = holder.vector.getAccessor();
            UInt8Holder innerHolder = new UInt8Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedUInt8Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedUInt8Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<Long> getObject(int index) {
            JsonStringArrayList<Long> vals = new JsonStringArrayList<Long>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedUInt8Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            UInt8Vector.Accessor valuesAccessor = RepeatedUInt8Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Long getSingleObject(int index, int arrayIndex) {
            int start = RepeatedUInt8Vector.this.offsets.getAccessor().get(index);
            return RepeatedUInt8Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public long get(int index, int positionIndex) {
            return RepeatedUInt8Vector.this.values.getAccessor().get(RepeatedUInt8Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedUInt8Holder holder) {
            holder.start = RepeatedUInt8Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedUInt8Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedUInt8Vector.this.values;
            holder.reader = RepeatedUInt8Vector.this.reader;
        }

        public void get(int index, int positionIndex, UInt8Holder holder) {
            int offset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedUInt8Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableUInt8Holder holder) {
            int offset = RepeatedUInt8Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedUInt8Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedUInt8Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedUInt8Vector(field, allocator);
        }

        public TransferImpl(RepeatedUInt8Vector to) {
            this.to = to;
        }

        @Override
        public RepeatedUInt8Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedUInt8Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedUInt8Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedUInt8Vector.this);
        }
    }
}

