/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.BitHolder;
import oadd.org.apache.drill.exec.expr.holders.DateHolder;
import oadd.org.apache.drill.exec.expr.holders.Decimal18Holder;
import oadd.org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.Decimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.Float4Holder;
import oadd.org.apache.drill.exec.expr.holders.Float8Holder;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.IntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.IntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBitHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueHolderHelper {
    static final Logger logger = LoggerFactory.getLogger(ValueHolderHelper.class);

    public static IntHolder getIntHolder(int value) {
        IntHolder holder = new IntHolder();
        holder.value = value;
        return holder;
    }

    public static BigIntHolder getBigIntHolder(long value) {
        BigIntHolder holder = new BigIntHolder();
        holder.value = value;
        return holder;
    }

    public static Float4Holder getFloat4Holder(float value) {
        Float4Holder holder = new Float4Holder();
        holder.value = value;
        return holder;
    }

    public static Float8Holder getFloat8Holder(double value) {
        Float8Holder holder = new Float8Holder();
        holder.value = value;
        return holder;
    }

    public static DateHolder getDateHolder(long value) {
        DateHolder holder = new DateHolder();
        holder.value = value;
        return holder;
    }

    public static TimeHolder getTimeHolder(int value) {
        TimeHolder holder = new TimeHolder();
        holder.value = value;
        return holder;
    }

    public static TimeStampHolder getTimeStampHolder(long value) {
        TimeStampHolder holder = new TimeStampHolder();
        holder.value = value;
        return holder;
    }

    public static BitHolder getBitHolder(int value) {
        BitHolder holder = new BitHolder();
        holder.value = value;
        return holder;
    }

    public static NullableBitHolder getNullableBitHolder(boolean isNull, int value) {
        NullableBitHolder holder = new NullableBitHolder();
        int n = holder.isSet = isNull ? 0 : 1;
        if (!isNull) {
            holder.value = value;
        }
        return holder;
    }

    public static VarCharHolder getVarCharHolder(DrillBuf buf, String s) {
        VarCharHolder vch = new VarCharHolder();
        byte[] b = s.getBytes(Charsets.UTF_8);
        vch.start = 0;
        vch.end = b.length;
        vch.buffer = buf.reallocIfNeeded(b.length);
        vch.buffer.setBytes(0, b);
        return vch;
    }

    public static VarCharHolder getVarCharHolder(BufferAllocator a, String s) {
        VarCharHolder vch = new VarCharHolder();
        byte[] b = s.getBytes(Charsets.UTF_8);
        vch.start = 0;
        vch.end = b.length;
        vch.buffer = a.buffer(b.length);
        vch.buffer.setBytes(0, b);
        return vch;
    }

    public static IntervalYearHolder getIntervalYearHolder(int intervalYear) {
        IntervalYearHolder holder = new IntervalYearHolder();
        holder.value = intervalYear;
        return holder;
    }

    public static IntervalDayHolder getIntervalDayHolder(int days, int millis) {
        IntervalDayHolder dch = new IntervalDayHolder();
        dch.days = days;
        dch.milliseconds = millis;
        return dch;
    }

    public static Decimal9Holder getDecimal9Holder(int decimal, int scale, int precision) {
        Decimal9Holder dch = new Decimal9Holder();
        dch.scale = scale;
        dch.precision = precision;
        dch.value = decimal;
        return dch;
    }

    public static Decimal18Holder getDecimal18Holder(long decimal, int scale, int precision) {
        Decimal18Holder dch = new Decimal18Holder();
        dch.scale = scale;
        dch.precision = precision;
        dch.value = decimal;
        return dch;
    }

    public static Decimal28SparseHolder getDecimal28Holder(DrillBuf buf, String decimal) {
        BigDecimal bigDecimal = new BigDecimal(decimal);
        return ValueHolderHelper.getDecimal28Holder(buf, bigDecimal);
    }

    public static Decimal28SparseHolder getDecimal28Holder(DrillBuf buf, BigDecimal bigDecimal) {
        Decimal28SparseHolder dch = new Decimal28SparseHolder();
        dch.scale = bigDecimal.scale();
        dch.precision = bigDecimal.precision();
        Decimal28SparseHolder.setSign(bigDecimal.signum() == -1, dch.start, dch.buffer);
        dch.start = 0;
        dch.buffer = buf.reallocIfNeeded(20);
        DecimalUtility.getSparseFromBigDecimal(bigDecimal, dch.buffer, dch.start, dch.scale, 5);
        return dch;
    }

    public static Decimal38SparseHolder getDecimal38Holder(DrillBuf buf, String decimal) {
        BigDecimal bigDecimal = new BigDecimal(decimal);
        return ValueHolderHelper.getDecimal38Holder(buf, bigDecimal);
    }

    public static Decimal38SparseHolder getDecimal38Holder(DrillBuf buf, BigDecimal bigDecimal) {
        Decimal38SparseHolder dch = new Decimal38SparseHolder();
        dch.scale = bigDecimal.scale();
        dch.precision = bigDecimal.precision();
        Decimal38SparseHolder.setSign(bigDecimal.signum() == -1, dch.start, dch.buffer);
        dch.start = 0;
        dch.buffer = buf.reallocIfNeeded(152);
        DecimalUtility.getSparseFromBigDecimal(bigDecimal, dch.buffer, dch.start, dch.scale, 6);
        return dch;
    }

    public static VarDecimalHolder getVarDecimalHolder(DrillBuf buf, String decimal) {
        BigDecimal bigDecimal = new BigDecimal(decimal);
        return ValueHolderHelper.getVarDecimalHolder(buf, bigDecimal);
    }

    public static VarDecimalHolder getVarDecimalHolder(DrillBuf buf, BigDecimal bigDecimal) {
        VarDecimalHolder dch = new VarDecimalHolder();
        byte[] bytes = bigDecimal.unscaledValue().toByteArray();
        int length = bytes.length;
        dch.scale = bigDecimal.scale();
        dch.precision = bigDecimal.precision();
        dch.start = 0;
        dch.end = length;
        dch.buffer = buf.reallocIfNeeded(length);
        dch.buffer.setBytes(0, bytes);
        return dch;
    }

    public static List<String> getHolderParams(TypeProtos.MajorType type) {
        ArrayList<String> result = new ArrayList<String>();
        switch (type.getMode()) {
            case OPTIONAL: {
                result.add("isSet");
            }
            case REQUIRED: {
                switch (type.getMinorType()) {
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case INT: 
                    case MONEY: 
                    case SMALLINT: 
                    case TINYINT: 
                    case UINT1: 
                    case UINT2: 
                    case UINT4: 
                    case UINT8: 
                    case INTERVALYEAR: 
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: 
                    case BIT: 
                    case DECIMAL9: 
                    case DECIMAL18: {
                        result.add("value");
                        return result;
                    }
                    case DECIMAL28DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL38SPARSE: {
                        result.add("start");
                        result.add("buffer");
                        result.add("scale");
                        result.add("precision");
                        return result;
                    }
                    case INTERVAL: {
                        result.add("months");
                        result.add("days");
                        result.add("milliseconds");
                        return result;
                    }
                    case INTERVALDAY: {
                        result.add("days");
                        result.add("milliseconds");
                        return result;
                    }
                    case VARDECIMAL: {
                        result.add("scale");
                        result.add("precision");
                    }
                    case VAR16CHAR: 
                    case VARBINARY: 
                    case VARCHAR: {
                        result.add("start");
                        result.add("end");
                        result.add("buffer");
                        return result;
                    }
                    case UNION: {
                        result.add("reader");
                        return result;
                    }
                }
            }
        }
        return result;
    }
}

