/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.VariantWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractFixedWidthWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.ColumnWriterFactory;
import oadd.org.apache.drill.exec.vector.accessor.writer.UnionWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;

public class UnionVectorShim
implements UnionWriterImpl.UnionShim {
    private final UnionVector vector;
    private final AbstractObjectWriter[] variants;
    private UnionWriterImpl writer;
    private final BaseScalarWriter typeWriter;

    public UnionVectorShim(UnionVector vector) {
        this.vector = vector;
        this.typeWriter = ColumnWriterFactory.newWriter(vector.getTypeVector());
        this.variants = new AbstractObjectWriter[TypeProtos.MinorType.values().length];
    }

    public UnionVectorShim(UnionVector vector, AbstractObjectWriter[] variants) {
        this.vector = vector;
        this.typeWriter = ColumnWriterFactory.newWriter(vector.getTypeVector());
        this.variants = variants == null ? new AbstractObjectWriter[TypeProtos.MinorType.values().length] : variants;
    }

    @Override
    public void bindWriter(UnionWriterImpl writer) {
        this.writer = writer;
        ColumnWriterIndex index = writer.index();
        if (index != null) {
            this.bindIndex(index);
        }
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.typeWriter.bindIndex(index);
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().bindIndex(index);
        }
    }

    @Override
    public void bindListener(WriterEvents.ColumnWriterListener listener) {
    }

    @Override
    public void setNull() {
        this.typeWriter.setInt(0);
    }

    @Override
    public boolean hasType(TypeProtos.MinorType type) {
        return this.variants[type.ordinal()] != null;
    }

    @Override
    public ObjectWriter member(TypeProtos.MinorType type) {
        AbstractObjectWriter colWriter = this.variants[type.ordinal()];
        if (colWriter != null) {
            return colWriter;
        }
        if (this.writer.listener() == null) {
            this.writer.bindListener(new DefaultListener(this));
        }
        return this.addMember(type);
    }

    @Override
    public void setType(TypeProtos.MinorType type) {
        this.typeWriter.setInt(type.getNumber());
    }

    @Override
    public AbstractObjectWriter addMember(ColumnMetadata schema) {
        AbstractObjectWriter colWriter = (AbstractObjectWriter)this.writer.listener().addMember(schema);
        this.addMember(colWriter);
        return colWriter;
    }

    @Override
    public AbstractObjectWriter addMember(TypeProtos.MinorType type) {
        AbstractObjectWriter colWriter = (AbstractObjectWriter)this.writer.listener().addType(type);
        this.addMember(colWriter);
        return colWriter;
    }

    @Override
    public void addMember(AbstractObjectWriter colWriter) {
        this.addMemberWriter(colWriter);
        this.writer.addMember(colWriter);
    }

    public void addMemberWriter(AbstractObjectWriter colWriter) {
        TypeProtos.MinorType type = colWriter.schema().type();
        assert (this.variants[type.ordinal()] == null);
        this.variants[type.ordinal()] = colWriter;
    }

    @Override
    public void startWrite() {
        this.typeWriter.startWrite();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().startWrite();
        }
    }

    @Override
    public void startRow() {
        this.typeWriter.startRow();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().startRow();
        }
    }

    @Override
    public void endArrayValue() {
        this.typeWriter.endArrayValue();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().endArrayValue();
        }
    }

    @Override
    public void restartRow() {
        this.typeWriter.restartRow();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().restartRow();
        }
    }

    @Override
    public void saveRow() {
        this.typeWriter.saveRow();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().saveRow();
        }
    }

    @Override
    public void preRollover() {
        this.typeWriter.preRollover();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().preRollover();
        }
    }

    @Override
    public void postRollover() {
        this.typeWriter.postRollover();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().postRollover();
        }
    }

    @Override
    public void endWrite() {
        this.typeWriter.endWrite();
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variants[i] == null) continue;
            this.variants[i].events().endWrite();
        }
    }

    public AbstractScalarWriterImpl typeWriter() {
        return this.typeWriter;
    }

    @Override
    public int writeIndex() {
        return this.typeWriter.writeIndex();
    }

    @Override
    public int lastWriteIndex() {
        return this.typeWriter.lastWriteIndex();
    }

    @Override
    public int rowStartIndex() {
        return this.typeWriter.rowStartIndex();
    }

    public void initTypeIndex(int typeFillCount) {
        ((AbstractFixedWidthWriter.BaseFixedWidthWriter)this.typeWriter).setLastWriteIndex(typeFillCount);
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("typeWriter");
        this.typeWriter.dump(format);
        format.endObject();
    }

    static class DefaultListener
    implements VariantWriter.VariantWriterListener {
        private final UnionVectorShim shim;

        private DefaultListener(UnionVectorShim shim) {
            this.shim = shim;
        }

        @Override
        public ObjectWriter addType(TypeProtos.MinorType type) {
            ValueVector memberVector = this.shim.vector.getMember(type);
            ColumnMetadata memberSchema = this.shim.writer.variantSchema().addType(type);
            return ColumnWriterFactory.buildColumnWriter(memberSchema, null, memberVector);
        }

        @Override
        public ObjectWriter addMember(ColumnMetadata schema) {
            throw new UnsupportedOperationException();
        }
    }
}

