/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.ComplexHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBitHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDateHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import oadd.org.apache.drill.exec.expr.holders.UnionHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.NullableBigIntVector;
import oadd.org.apache.drill.exec.vector.NullableBitVector;
import oadd.org.apache.drill.exec.vector.NullableDateVector;
import oadd.org.apache.drill.exec.vector.NullableFloat4Vector;
import oadd.org.apache.drill.exec.vector.NullableFloat8Vector;
import oadd.org.apache.drill.exec.vector.NullableIntVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalDayVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalYearVector;
import oadd.org.apache.drill.exec.vector.NullableSmallIntVector;
import oadd.org.apache.drill.exec.vector.NullableTimeStampVector;
import oadd.org.apache.drill.exec.vector.NullableTimeVector;
import oadd.org.apache.drill.exec.vector.NullableTinyIntVector;
import oadd.org.apache.drill.exec.vector.NullableUInt1Vector;
import oadd.org.apache.drill.exec.vector.NullableUInt2Vector;
import oadd.org.apache.drill.exec.vector.NullableUInt4Vector;
import oadd.org.apache.drill.exec.vector.NullableUInt8Vector;
import oadd.org.apache.drill.exec.vector.NullableVar16CharVector;
import oadd.org.apache.drill.exec.vector.NullableVarBinaryVector;
import oadd.org.apache.drill.exec.vector.NullableVarCharVector;
import oadd.org.apache.drill.exec.vector.NullableVarDecimalVector;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.ListVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionReader;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class UnionVector
implements ValueVector {
    public static final int NULL_MARKER = 0;
    public static final String TYPE_VECTOR_NAME = "types";
    public static final String INTERNAL_MAP_NAME = "internal";
    private static final TypeProtos.MajorType[] MAJOR_TYPES = new TypeProtos.MajorType[TypeProtos.MinorType.values().length];
    private MaterializedField field;
    private BufferAllocator allocator;
    private Accessor accessor = new Accessor();
    private Mutator mutator = new Mutator();
    private int valueCount;
    private MapVector internalMap;
    private UInt1Vector typeVector;
    private ValueVector[] cachedSubtypes = new ValueVector[TypeProtos.MinorType.values().length];
    private FieldReader reader;
    private final CallBack callBack;

    public UnionVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this.field = field.clone();
        this.allocator = allocator;
        this.internalMap = new MapVector(INTERNAL_MAP_NAME, allocator, callBack);
        this.typeVector = this.internalMap.addOrGet(TYPE_VECTOR_NAME, Types.required(TypeProtos.MinorType.UINT1), UInt1Vector.class);
        this.field.addChild(this.internalMap.getField().clone());
        this.callBack = callBack;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public List<TypeProtos.MinorType> getSubTypes() {
        return this.field.getType().getSubTypeList();
    }

    public <T extends ValueVector> T subtype(TypeProtos.MinorType type) {
        return (T)this.cachedSubtypes[type.ordinal()];
    }

    public void addType(ValueVector vector) {
        TypeProtos.MinorType type = vector.getField().getType().getMinorType();
        assert (this.subtype(type) == null);
        assert (vector.getField().getType().getMode() == TypeProtos.DataMode.OPTIONAL);
        assert (vector.getField().getName().equals(type.name().toLowerCase()));
        this.cachedSubtypes[type.ordinal()] = vector;
        this.internalMap.putChild(type.name(), vector);
        this.addSubType(type);
    }

    public void addSubType(TypeProtos.MinorType type) {
        if (this.field.getType().getSubTypeList().contains(type)) {
            return;
        }
        this.field.replaceType(TypeProtos.MajorType.newBuilder(this.field.getType()).addSubType(type).build());
        if (this.callBack != null) {
            this.callBack.doWork();
        }
    }

    private <T extends ValueVector> T classicAddType(TypeProtos.MinorType type, Class<? extends ValueVector> vectorClass) {
        ValueVector vector;
        int vectorCount = this.internalMap.size();
        this.cachedSubtypes[type.ordinal()] = vector = this.internalMap.addOrGet(type.name().toLowerCase(), MAJOR_TYPES[type.ordinal()], vectorClass);
        if (this.internalMap.size() > vectorCount) {
            vector.allocateNew();
            this.addSubType(type);
            if (this.callBack != null) {
                this.callBack.doWork();
            }
        }
        return (T)vector;
    }

    public MapVector getMap() {
        MapVector mapVector = (MapVector)this.subtype(TypeProtos.MinorType.MAP);
        if (mapVector == null) {
            mapVector = (MapVector)this.classicAddType(TypeProtos.MinorType.MAP, MapVector.class);
        }
        return mapVector;
    }

    public ListVector getList() {
        ListVector listVector = (ListVector)this.subtype(TypeProtos.MinorType.LIST);
        if (listVector == null) {
            listVector = (ListVector)this.classicAddType(TypeProtos.MinorType.LIST, ListVector.class);
        }
        return listVector;
    }

    public NullableTinyIntVector getTinyIntVector() {
        NullableTinyIntVector vector = (NullableTinyIntVector)this.subtype(TypeProtos.MinorType.TINYINT);
        if (vector == null) {
            vector = (NullableTinyIntVector)this.classicAddType(TypeProtos.MinorType.TINYINT, NullableTinyIntVector.class);
        }
        return vector;
    }

    public NullableUInt1Vector getUInt1Vector() {
        NullableUInt1Vector vector = (NullableUInt1Vector)this.subtype(TypeProtos.MinorType.UINT1);
        if (vector == null) {
            vector = (NullableUInt1Vector)this.classicAddType(TypeProtos.MinorType.UINT1, NullableUInt1Vector.class);
        }
        return vector;
    }

    public NullableUInt2Vector getUInt2Vector() {
        NullableUInt2Vector vector = (NullableUInt2Vector)this.subtype(TypeProtos.MinorType.UINT2);
        if (vector == null) {
            vector = (NullableUInt2Vector)this.classicAddType(TypeProtos.MinorType.UINT2, NullableUInt2Vector.class);
        }
        return vector;
    }

    public NullableSmallIntVector getSmallIntVector() {
        NullableSmallIntVector vector = (NullableSmallIntVector)this.subtype(TypeProtos.MinorType.SMALLINT);
        if (vector == null) {
            vector = (NullableSmallIntVector)this.classicAddType(TypeProtos.MinorType.SMALLINT, NullableSmallIntVector.class);
        }
        return vector;
    }

    public NullableIntVector getIntVector() {
        NullableIntVector vector = (NullableIntVector)this.subtype(TypeProtos.MinorType.INT);
        if (vector == null) {
            vector = (NullableIntVector)this.classicAddType(TypeProtos.MinorType.INT, NullableIntVector.class);
        }
        return vector;
    }

    public NullableUInt4Vector getUInt4Vector() {
        NullableUInt4Vector vector = (NullableUInt4Vector)this.subtype(TypeProtos.MinorType.UINT4);
        if (vector == null) {
            vector = (NullableUInt4Vector)this.classicAddType(TypeProtos.MinorType.UINT4, NullableUInt4Vector.class);
        }
        return vector;
    }

    public NullableFloat4Vector getFloat4Vector() {
        NullableFloat4Vector vector = (NullableFloat4Vector)this.subtype(TypeProtos.MinorType.FLOAT4);
        if (vector == null) {
            vector = (NullableFloat4Vector)this.classicAddType(TypeProtos.MinorType.FLOAT4, NullableFloat4Vector.class);
        }
        return vector;
    }

    public NullableTimeVector getTimeVector() {
        NullableTimeVector vector = (NullableTimeVector)this.subtype(TypeProtos.MinorType.TIME);
        if (vector == null) {
            vector = (NullableTimeVector)this.classicAddType(TypeProtos.MinorType.TIME, NullableTimeVector.class);
        }
        return vector;
    }

    public NullableIntervalYearVector getIntervalYearVector() {
        NullableIntervalYearVector vector = (NullableIntervalYearVector)this.subtype(TypeProtos.MinorType.INTERVALYEAR);
        if (vector == null) {
            vector = (NullableIntervalYearVector)this.classicAddType(TypeProtos.MinorType.INTERVALYEAR, NullableIntervalYearVector.class);
        }
        return vector;
    }

    public NullableBigIntVector getBigIntVector() {
        NullableBigIntVector vector = (NullableBigIntVector)this.subtype(TypeProtos.MinorType.BIGINT);
        if (vector == null) {
            vector = (NullableBigIntVector)this.classicAddType(TypeProtos.MinorType.BIGINT, NullableBigIntVector.class);
        }
        return vector;
    }

    public NullableUInt8Vector getUInt8Vector() {
        NullableUInt8Vector vector = (NullableUInt8Vector)this.subtype(TypeProtos.MinorType.UINT8);
        if (vector == null) {
            vector = (NullableUInt8Vector)this.classicAddType(TypeProtos.MinorType.UINT8, NullableUInt8Vector.class);
        }
        return vector;
    }

    public NullableFloat8Vector getFloat8Vector() {
        NullableFloat8Vector vector = (NullableFloat8Vector)this.subtype(TypeProtos.MinorType.FLOAT8);
        if (vector == null) {
            vector = (NullableFloat8Vector)this.classicAddType(TypeProtos.MinorType.FLOAT8, NullableFloat8Vector.class);
        }
        return vector;
    }

    public NullableDateVector getDateVector() {
        NullableDateVector vector = (NullableDateVector)this.subtype(TypeProtos.MinorType.DATE);
        if (vector == null) {
            vector = (NullableDateVector)this.classicAddType(TypeProtos.MinorType.DATE, NullableDateVector.class);
        }
        return vector;
    }

    public NullableTimeStampVector getTimeStampVector() {
        NullableTimeStampVector vector = (NullableTimeStampVector)this.subtype(TypeProtos.MinorType.TIMESTAMP);
        if (vector == null) {
            vector = (NullableTimeStampVector)this.classicAddType(TypeProtos.MinorType.TIMESTAMP, NullableTimeStampVector.class);
        }
        return vector;
    }

    public NullableIntervalDayVector getIntervalDayVector() {
        NullableIntervalDayVector vector = (NullableIntervalDayVector)this.subtype(TypeProtos.MinorType.INTERVALDAY);
        if (vector == null) {
            vector = (NullableIntervalDayVector)this.classicAddType(TypeProtos.MinorType.INTERVALDAY, NullableIntervalDayVector.class);
        }
        return vector;
    }

    public NullableIntervalVector getIntervalVector() {
        NullableIntervalVector vector = (NullableIntervalVector)this.subtype(TypeProtos.MinorType.INTERVAL);
        if (vector == null) {
            vector = (NullableIntervalVector)this.classicAddType(TypeProtos.MinorType.INTERVAL, NullableIntervalVector.class);
        }
        return vector;
    }

    public NullableVarBinaryVector getVarBinaryVector() {
        NullableVarBinaryVector vector = (NullableVarBinaryVector)this.subtype(TypeProtos.MinorType.VARBINARY);
        if (vector == null) {
            vector = (NullableVarBinaryVector)this.classicAddType(TypeProtos.MinorType.VARBINARY, NullableVarBinaryVector.class);
        }
        return vector;
    }

    public NullableVarCharVector getVarCharVector() {
        NullableVarCharVector vector = (NullableVarCharVector)this.subtype(TypeProtos.MinorType.VARCHAR);
        if (vector == null) {
            vector = (NullableVarCharVector)this.classicAddType(TypeProtos.MinorType.VARCHAR, NullableVarCharVector.class);
        }
        return vector;
    }

    public NullableVar16CharVector getVar16CharVector() {
        NullableVar16CharVector vector = (NullableVar16CharVector)this.subtype(TypeProtos.MinorType.VAR16CHAR);
        if (vector == null) {
            vector = (NullableVar16CharVector)this.classicAddType(TypeProtos.MinorType.VAR16CHAR, NullableVar16CharVector.class);
        }
        return vector;
    }

    public NullableVarDecimalVector getVarDecimalVector() {
        NullableVarDecimalVector vector = (NullableVarDecimalVector)this.subtype(TypeProtos.MinorType.VARDECIMAL);
        if (vector == null) {
            vector = (NullableVarDecimalVector)this.classicAddType(TypeProtos.MinorType.VARDECIMAL, NullableVarDecimalVector.class);
        }
        return vector;
    }

    public NullableBitVector getBitVector() {
        NullableBitVector vector = (NullableBitVector)this.subtype(TypeProtos.MinorType.BIT);
        if (vector == null) {
            vector = (NullableBitVector)this.classicAddType(TypeProtos.MinorType.BIT, NullableBitVector.class);
        }
        return vector;
    }

    public ValueVector getMember(TypeProtos.MinorType type) {
        switch (type) {
            case MAP: {
                return this.getMap();
            }
            case LIST: {
                return this.getList();
            }
            case TINYINT: {
                return this.getTinyIntVector();
            }
            case UINT1: {
                return this.getUInt1Vector();
            }
            case UINT2: {
                return this.getUInt2Vector();
            }
            case SMALLINT: {
                return this.getSmallIntVector();
            }
            case INT: {
                return this.getIntVector();
            }
            case UINT4: {
                return this.getUInt4Vector();
            }
            case FLOAT4: {
                return this.getFloat4Vector();
            }
            case TIME: {
                return this.getTimeVector();
            }
            case INTERVALYEAR: {
                return this.getIntervalYearVector();
            }
            case BIGINT: {
                return this.getBigIntVector();
            }
            case UINT8: {
                return this.getUInt8Vector();
            }
            case FLOAT8: {
                return this.getFloat8Vector();
            }
            case DATE: {
                return this.getDateVector();
            }
            case TIMESTAMP: {
                return this.getTimeStampVector();
            }
            case INTERVALDAY: {
                return this.getIntervalDayVector();
            }
            case INTERVAL: {
                return this.getIntervalVector();
            }
            case VARBINARY: {
                return this.getVarBinaryVector();
            }
            case VARCHAR: {
                return this.getVarCharVector();
            }
            case VAR16CHAR: {
                return this.getVar16CharVector();
            }
            case VARDECIMAL: {
                return this.getVarDecimalVector();
            }
            case BIT: {
                return this.getBitVector();
            }
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public <T extends ValueVector> T member(TypeProtos.MinorType type) {
        return (T)this.getMember(type);
    }

    public int getTypeValue(int index) {
        return this.getTypeVector().getAccessor().get(index);
    }

    public UInt1Vector getTypeVector() {
        if (this.typeVector == null) {
            this.typeVector = (UInt1Vector)this.internalMap.getChild(TYPE_VECTOR_NAME);
        }
        return this.typeVector;
    }

    @VisibleForTesting
    public MapVector getTypeMap() {
        return this.internalMap;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.internalMap.allocateNew();
        this.getTypeVector().zeroVector();
    }

    public void allocateNew(int rowCount) throws OutOfMemoryException {
        this.internalMap.allocateNew();
        this.getTypeVector().zeroVector();
    }

    @Override
    public boolean allocateNewSafe() {
        boolean safe = this.internalMap.allocateNewSafe();
        if (safe) {
            this.getTypeVector().zeroVector();
        }
        return safe;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.getTypeVector().getValueCapacity(), this.internalMap.getValueCapacity());
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.internalMap.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.internalMap.getPayloadByteCount(valueCount);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.field, allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.field.withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((UnionVector)target);
    }

    public void transferTo(UnionVector target) {
        this.internalMap.makeTransferPair(target.internalMap).transfer();
        target.valueCount = this.valueCount;
    }

    public void copyFrom(int inIndex, int outIndex, UnionVector from) {
        from.getReader().setPosition(inIndex);
        this.getWriter().setPosition(outIndex);
        ComplexCopier.copy(from.reader, this.mutator.writer);
    }

    public void copyFromSafe(int inIndex, int outIndex, UnionVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (UnionVector)from);
    }

    public ValueVector addVector(ValueVector v) {
        String name = v.getField().getType().getMinorType().name().toLowerCase();
        TypeProtos.MajorType type = v.getField().getType();
        TypeProtos.MinorType minorType = type.getMinorType();
        Preconditions.checkState(this.internalMap.getChild(name) == null, String.format("%s vector already exists", name));
        ValueVector newVector = this.internalMap.addOrGet(name, type, BasicTypeHelper.getValueVectorClass(minorType, type.getMode()));
        v.makeTransferPair(newVector).transfer();
        this.internalMap.putChild(name, newVector);
        this.cachedSubtypes[minorType.ordinal()] = newVector;
        this.addSubType(minorType);
        return newVector;
    }

    public ValueVector setFirstType(ValueVector v, int newValueCount) {
        Preconditions.checkState(this.accessor.getValueCount() == 0);
        ValueVector vv = this.addVector(v);
        TypeProtos.MinorType type = v.getField().getType().getMinorType();
        ValueVector.Accessor vAccessor = vv.getAccessor();
        for (int i = 0; i < newValueCount; ++i) {
            if (!vAccessor.isNull(i)) {
                this.mutator.setType(i, type);
                continue;
            }
            this.mutator.setNull(i);
        }
        this.mutator.setValueCount(newValueCount);
        return vv;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public FieldReader getReader() {
        if (this.reader == null) {
            this.reader = new UnionReader(this);
        }
        return this.reader;
    }

    public FieldWriter getWriter() {
        if (this.mutator.writer == null) {
            this.mutator.writer = new UnionWriter(this);
        }
        return this.mutator.writer;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.valueCount).addChild(this.internalMap.getMetadata()).build();
    }

    @Override
    public int getBufferSize() {
        return this.internalMap.getBufferSize();
    }

    @Override
    public int getAllocatedSize() {
        return this.internalMap.getAllocatedSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = 0L;
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return this.internalMap.getBuffers(clear);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.valueCount = metadata.getValueCount();
        this.internalMap.load(metadata.getChild(0), buffer);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.internalMap.iterator();
    }

    @Override
    public void exchange(ValueVector other) {
        throw new UnsupportedOperationException("Union vector does not yet support exchange()");
    }

    static {
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.MAP.ordinal()] = Types.optional(TypeProtos.MinorType.MAP);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.LIST.ordinal()] = Types.optional(TypeProtos.MinorType.LIST);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.TINYINT.ordinal()] = Types.optional(TypeProtos.MinorType.TINYINT);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.UINT1.ordinal()] = Types.optional(TypeProtos.MinorType.UINT1);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.UINT2.ordinal()] = Types.optional(TypeProtos.MinorType.UINT2);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.SMALLINT.ordinal()] = Types.optional(TypeProtos.MinorType.SMALLINT);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.INT.ordinal()] = Types.optional(TypeProtos.MinorType.INT);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.UINT4.ordinal()] = Types.optional(TypeProtos.MinorType.UINT4);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.FLOAT4.ordinal()] = Types.optional(TypeProtos.MinorType.FLOAT4);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.TIME.ordinal()] = Types.optional(TypeProtos.MinorType.TIME);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.INTERVALYEAR.ordinal()] = Types.optional(TypeProtos.MinorType.INTERVALYEAR);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.BIGINT.ordinal()] = Types.optional(TypeProtos.MinorType.BIGINT);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.UINT8.ordinal()] = Types.optional(TypeProtos.MinorType.UINT8);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.FLOAT8.ordinal()] = Types.optional(TypeProtos.MinorType.FLOAT8);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.DATE.ordinal()] = Types.optional(TypeProtos.MinorType.DATE);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.TIMESTAMP.ordinal()] = Types.optional(TypeProtos.MinorType.TIMESTAMP);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.INTERVALDAY.ordinal()] = Types.optional(TypeProtos.MinorType.INTERVALDAY);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.INTERVAL.ordinal()] = Types.optional(TypeProtos.MinorType.INTERVAL);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.VARBINARY.ordinal()] = Types.optional(TypeProtos.MinorType.VARBINARY);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.VARCHAR.ordinal()] = Types.optional(TypeProtos.MinorType.VARCHAR);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.VAR16CHAR.ordinal()] = Types.optional(TypeProtos.MinorType.VAR16CHAR);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.VARDECIMAL.ordinal()] = Types.optional(TypeProtos.MinorType.VARDECIMAL);
        UnionVector.MAJOR_TYPES[TypeProtos.MinorType.BIT.ordinal()] = Types.optional(TypeProtos.MinorType.BIT);
    }

    public class Mutator
    extends BaseValueVector.BaseMutator {
        protected UnionWriter writer;

        @Override
        public void setValueCount(int valueCount) {
            UnionVector.this.valueCount = valueCount;
            UnionVector.this.internalMap.getMutator().setValueCount(valueCount);
        }

        public void setSafe(int index, UnionHolder holder) {
            FieldReader reader = holder.reader;
            if (this.writer == null) {
                this.writer = new UnionWriter(UnionVector.this);
            }
            this.writer.setPosition(index);
            TypeProtos.MinorType type = reader.getType().getMinorType();
            switch (type) {
                case TINYINT: {
                    NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                    reader.read(tinyIntHolder);
                    this.setSafe(index, tinyIntHolder);
                    break;
                }
                case UINT1: {
                    NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                    reader.read(uInt1Holder);
                    this.setSafe(index, uInt1Holder);
                    break;
                }
                case UINT2: {
                    NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                    reader.read(uInt2Holder);
                    this.setSafe(index, uInt2Holder);
                    break;
                }
                case SMALLINT: {
                    NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                    reader.read(smallIntHolder);
                    this.setSafe(index, smallIntHolder);
                    break;
                }
                case INT: {
                    NullableIntHolder intHolder = new NullableIntHolder();
                    reader.read(intHolder);
                    this.setSafe(index, intHolder);
                    break;
                }
                case UINT4: {
                    NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                    reader.read(uInt4Holder);
                    this.setSafe(index, uInt4Holder);
                    break;
                }
                case FLOAT4: {
                    NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                    reader.read(float4Holder);
                    this.setSafe(index, float4Holder);
                    break;
                }
                case TIME: {
                    NullableTimeHolder timeHolder = new NullableTimeHolder();
                    reader.read(timeHolder);
                    this.setSafe(index, timeHolder);
                    break;
                }
                case INTERVALYEAR: {
                    NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                    reader.read(intervalYearHolder);
                    this.setSafe(index, intervalYearHolder);
                    break;
                }
                case BIGINT: {
                    NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                    reader.read(bigIntHolder);
                    this.setSafe(index, bigIntHolder);
                    break;
                }
                case UINT8: {
                    NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                    reader.read(uInt8Holder);
                    this.setSafe(index, uInt8Holder);
                    break;
                }
                case FLOAT8: {
                    NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                    reader.read(float8Holder);
                    this.setSafe(index, float8Holder);
                    break;
                }
                case DATE: {
                    NullableDateHolder dateHolder = new NullableDateHolder();
                    reader.read(dateHolder);
                    this.setSafe(index, dateHolder);
                    break;
                }
                case TIMESTAMP: {
                    NullableTimeStampHolder timeStampHolder = new NullableTimeStampHolder();
                    reader.read(timeStampHolder);
                    this.setSafe(index, timeStampHolder);
                    break;
                }
                case INTERVALDAY: {
                    NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                    reader.read(intervalDayHolder);
                    this.setSafe(index, intervalDayHolder);
                    break;
                }
                case INTERVAL: {
                    NullableIntervalHolder intervalHolder = new NullableIntervalHolder();
                    reader.read(intervalHolder);
                    this.setSafe(index, intervalHolder);
                    break;
                }
                case VARBINARY: {
                    NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                    reader.read(varBinaryHolder);
                    this.setSafe(index, varBinaryHolder);
                    break;
                }
                case VARCHAR: {
                    NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                    reader.read(varCharHolder);
                    this.setSafe(index, varCharHolder);
                    break;
                }
                case VAR16CHAR: {
                    NullableVar16CharHolder var16CharHolder = new NullableVar16CharHolder();
                    reader.read(var16CharHolder);
                    this.setSafe(index, var16CharHolder);
                    break;
                }
                case VARDECIMAL: {
                    NullableVarDecimalHolder varDecimalHolder = new NullableVarDecimalHolder();
                    reader.read(varDecimalHolder);
                    this.setSafe(index, varDecimalHolder);
                    break;
                }
                case BIT: {
                    NullableBitHolder bitHolder = new NullableBitHolder();
                    reader.read(bitHolder);
                    this.setSafe(index, bitHolder);
                    break;
                }
                case MAP: {
                    ComplexCopier.copy(reader, this.writer);
                    break;
                }
                case LIST: {
                    ComplexCopier.copy(reader, this.writer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void setSafe(int index, NullableTinyIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.TINYINT);
            UnionVector.this.getTinyIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt1Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT1);
            UnionVector.this.getUInt1Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt2Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT2);
            UnionVector.this.getUInt2Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableSmallIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.SMALLINT);
            UnionVector.this.getSmallIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.INT);
            UnionVector.this.getIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt4Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT4);
            UnionVector.this.getUInt4Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableFloat4Holder holder) {
            this.setType(index, TypeProtos.MinorType.FLOAT4);
            UnionVector.this.getFloat4Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableTimeHolder holder) {
            this.setType(index, TypeProtos.MinorType.TIME);
            UnionVector.this.getTimeVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntervalYearHolder holder) {
            this.setType(index, TypeProtos.MinorType.INTERVALYEAR);
            UnionVector.this.getIntervalYearVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableBigIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.BIGINT);
            UnionVector.this.getBigIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt8Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT8);
            UnionVector.this.getUInt8Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableFloat8Holder holder) {
            this.setType(index, TypeProtos.MinorType.FLOAT8);
            UnionVector.this.getFloat8Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableDateHolder holder) {
            this.setType(index, TypeProtos.MinorType.DATE);
            UnionVector.this.getDateVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableTimeStampHolder holder) {
            this.setType(index, TypeProtos.MinorType.TIMESTAMP);
            UnionVector.this.getTimeStampVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntervalDayHolder holder) {
            this.setType(index, TypeProtos.MinorType.INTERVALDAY);
            UnionVector.this.getIntervalDayVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntervalHolder holder) {
            this.setType(index, TypeProtos.MinorType.INTERVAL);
            UnionVector.this.getIntervalVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVarBinaryHolder holder) {
            this.setType(index, TypeProtos.MinorType.VARBINARY);
            UnionVector.this.getVarBinaryVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVarCharHolder holder) {
            this.setType(index, TypeProtos.MinorType.VARCHAR);
            UnionVector.this.getVarCharVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVar16CharHolder holder) {
            this.setType(index, TypeProtos.MinorType.VAR16CHAR);
            UnionVector.this.getVar16CharVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVarDecimalHolder holder) {
            this.setType(index, TypeProtos.MinorType.VARDECIMAL);
            UnionVector.this.getVarDecimalVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableBitHolder holder) {
            this.setType(index, TypeProtos.MinorType.BIT);
            UnionVector.this.getBitVector().getMutator().setSafe(index, holder);
        }

        public void setType(int index, TypeProtos.MinorType type) {
            UnionVector.this.getTypeVector().getMutator().setSafe(index, type.getNumber());
        }

        public void setNull(int index) {
            UnionVector.this.getTypeVector().getMutator().setSafe(index, 0);
        }

        @Override
        public void reset() {
        }

        @Override
        public void generateTestData(int values) {
        }
    }

    public class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public Object getObject(int index) {
            byte type = UnionVector.this.getTypeVector().getAccessor().get(index);
            switch (type) {
                case 0: {
                    return null;
                }
                case 3: {
                    return UnionVector.this.getTinyIntVector().getAccessor().getObject(index);
                }
                case 29: {
                    return UnionVector.this.getUInt1Vector().getAccessor().getObject(index);
                }
                case 30: {
                    return UnionVector.this.getUInt2Vector().getAccessor().getObject(index);
                }
                case 4: {
                    return UnionVector.this.getSmallIntVector().getAccessor().getObject(index);
                }
                case 5: {
                    return UnionVector.this.getIntVector().getAccessor().getObject(index);
                }
                case 31: {
                    return UnionVector.this.getUInt4Vector().getAccessor().getObject(index);
                }
                case 18: {
                    return UnionVector.this.getFloat4Vector().getAccessor().getObject(index);
                }
                case 13: {
                    return UnionVector.this.getTimeVector().getAccessor().getObject(index);
                }
                case 38: {
                    return UnionVector.this.getIntervalYearVector().getAccessor().getObject(index);
                }
                case 6: {
                    return UnionVector.this.getBigIntVector().getAccessor().getObject(index);
                }
                case 32: {
                    return UnionVector.this.getUInt8Vector().getAccessor().getObject(index);
                }
                case 19: {
                    return UnionVector.this.getFloat8Vector().getAccessor().getObject(index);
                }
                case 12: {
                    return UnionVector.this.getDateVector().getAccessor().getObject(index);
                }
                case 16: {
                    return UnionVector.this.getTimeStampVector().getAccessor().getObject(index);
                }
                case 39: {
                    return UnionVector.this.getIntervalDayVector().getAccessor().getObject(index);
                }
                case 17: {
                    return UnionVector.this.getIntervalVector().getAccessor().getObject(index);
                }
                case 26: {
                    return UnionVector.this.getVarBinaryVector().getAccessor().getObject(index);
                }
                case 24: {
                    return UnionVector.this.getVarCharVector().getAccessor().getObject(index);
                }
                case 25: {
                    return UnionVector.this.getVar16CharVector().getAccessor().getObject(index);
                }
                case 43: {
                    return UnionVector.this.getVarDecimalVector().getAccessor().getObject(index);
                }
                case 20: {
                    return UnionVector.this.getBitVector().getAccessor().getObject(index);
                }
                case 1: {
                    return UnionVector.this.getMap().getAccessor().getObject(index);
                }
                case 40: {
                    return UnionVector.this.getList().getAccessor().getObject(index);
                }
            }
            throw new UnsupportedOperationException("Cannot support type: " + TypeProtos.MinorType.valueOf(type));
        }

        public byte[] get(int index) {
            return null;
        }

        public void get(int index, ComplexHolder holder) {
        }

        public void get(int index, UnionHolder holder) {
            UnionReader reader = new UnionReader(UnionVector.this);
            reader.setPosition(index);
            holder.reader = reader;
        }

        @Override
        public int getValueCount() {
            return UnionVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return UnionVector.this.getTypeVector().getAccessor().get(index) == 0;
        }

        public int isSet(int index) {
            return this.isNull(index) ? 0 : 1;
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final UnionVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new UnionVector(field, allocator, null);
        }

        public TransferImpl(UnionVector to) {
            this.to = to;
        }

        @Override
        public void transfer() {
            UnionVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, UnionVector.this);
        }
    }
}

