/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class FieldSelection {
    public static final FieldSelection INVALID_NODE = new FieldSelection(null, ValidityMode.NEVER_VALID);
    public static final FieldSelection ALL_VALID = new FieldSelection(null, ValidityMode.ALWAYS_VALID);
    private final Map<String, FieldSelection> children;
    private final Map<String, FieldSelection> childrenInsensitive;
    private ValidityMode mode;

    private FieldSelection() {
        this(new HashMap<String, FieldSelection>(), ValidityMode.CHECK_CHILDREN);
    }

    private FieldSelection(Map<String, FieldSelection> children, ValidityMode mode) {
        this.children = children;
        if (children != null) {
            this.childrenInsensitive = new TreeMap<String, FieldSelection>(String.CASE_INSENSITIVE_ORDER);
            this.childrenInsensitive.putAll(children);
        } else {
            this.childrenInsensitive = null;
        }
        this.mode = mode;
    }

    public String toString() {
        return super.toString() + "[mode = " + (Object)((Object)this.mode) + ", children = " + this.children + ", childrenInsensitive = " + this.childrenInsensitive + "]";
    }

    private FieldSelection fixNodes() {
        if (this.children.isEmpty()) {
            return ALL_VALID;
        }
        HashMap<String, FieldSelection> newMap = Maps.newHashMap();
        for (Map.Entry<String, FieldSelection> e : this.children.entrySet()) {
            newMap.put(e.getKey(), e.getValue().fixNodes());
        }
        return new FieldSelection(newMap, this.mode);
    }

    private FieldSelection addChild(String name) {
        if (this.children.containsKey(name = name.toLowerCase())) {
            return this.children.get(name);
        }
        FieldSelection n = new FieldSelection();
        this.children.put(name, n);
        return n;
    }

    private void add(PathSegment segment) {
        if (segment.isNamed()) {
            boolean lastPath = segment.isLastPath();
            FieldSelection child = this.addChild(segment.getNameSegment().getPath());
            if (lastPath) {
                child.setAlwaysValid();
            }
            if (!lastPath && !child.isAlwaysValid()) {
                child.add(segment.getChild());
            }
        }
    }

    public boolean isNeverValid() {
        return this.mode == ValidityMode.NEVER_VALID;
    }

    private void setAlwaysValid() {
        this.mode = ValidityMode.ALWAYS_VALID;
    }

    public boolean isAlwaysValid() {
        return this.mode == ValidityMode.ALWAYS_VALID;
    }

    public FieldSelection getChild(String name) {
        switch (this.mode) {
            case ALWAYS_VALID: {
                return ALL_VALID;
            }
            case CHECK_CHILDREN: {
                FieldSelection n = this.children.get(name);
                if (n == null && (n = this.childrenInsensitive.get(name)) != null) {
                    this.children.put(name, n);
                }
                if (n == null) {
                    return INVALID_NODE;
                }
                return n;
            }
            case NEVER_VALID: {
                return INVALID_NODE;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean containsStar(List<SchemaPath> columns) {
        for (SchemaPath expr : columns) {
            if (!"**".equals(expr.getRootSegment().getPath())) continue;
            return true;
        }
        return false;
    }

    public static FieldSelection getFieldSelection(List<SchemaPath> fields) {
        if (FieldSelection.containsStar(fields)) {
            return ALL_VALID;
        }
        FieldSelection root = new FieldSelection();
        for (SchemaPath p : fields) {
            root.add(p.getRootSegment());
        }
        return root.fixNodes();
    }

    private static enum ValidityMode {
        CHECK_CHILDREN,
        NEVER_VALID,
        ALWAYS_VALID;

    }
}

