/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class NullableVarDecimalHolderReaderImpl
extends AbstractFieldReader {
    private NullableVarDecimalHolder holder;

    public NullableVarDecimalHolderReaderImpl(NullableVarDecimalHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(VarDecimalHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
        h.scale = this.holder.scale;
        h.precision = this.holder.precision;
    }

    @Override
    public void read(NullableVarDecimalHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
        h.scale = this.holder.scale;
        h.precision = this.holder.precision;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        return DecimalUtility.getBigDecimalFromDrillBuf(this.holder.buffer, this.holder.start, this.holder.end - this.holder.start, this.holder.scale);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        return DecimalUtility.getBigDecimalFromDrillBuf(this.holder.buffer, this.holder.start, this.holder.end - this.holder.start, this.holder.scale);
    }
}

