/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.BlockLocation;
import oadd.org.apache.hadoop.fs.ContentSummary;
import oadd.org.apache.hadoop.fs.CreateFlag;
import oadd.org.apache.hadoop.fs.FSDataInputStream;
import oadd.org.apache.hadoop.fs.FSDataOutputStream;
import oadd.org.apache.hadoop.fs.FileAlreadyExistsException;
import oadd.org.apache.hadoop.fs.FileChecksum;
import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.FsConstants;
import oadd.org.apache.hadoop.fs.FsServerDefaults;
import oadd.org.apache.hadoop.fs.LocatedFileStatus;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathFilter;
import oadd.org.apache.hadoop.fs.RemoteIterator;
import oadd.org.apache.hadoop.fs.UnsupportedFileSystemException;
import oadd.org.apache.hadoop.fs.XAttrSetFlag;
import oadd.org.apache.hadoop.fs.permission.AclEntry;
import oadd.org.apache.hadoop.fs.permission.AclStatus;
import oadd.org.apache.hadoop.fs.permission.AclUtil;
import oadd.org.apache.hadoop.fs.permission.FsAction;
import oadd.org.apache.hadoop.fs.permission.FsPermission;
import oadd.org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import oadd.org.apache.hadoop.fs.viewfs.Constants;
import oadd.org.apache.hadoop.fs.viewfs.InodeTree;
import oadd.org.apache.hadoop.fs.viewfs.NotInMountpointException;
import oadd.org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import oadd.org.apache.hadoop.fs.viewfs.ViewFsLocatedFileStatus;
import oadd.org.apache.hadoop.security.AccessControlException;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import oadd.org.apache.hadoop.util.Progressable;
import oadd.org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFileSystem
extends FileSystem {
    private static final Path ROOT_PATH = new Path("/");
    final long creationTime;
    final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
    URI myUri;
    private Path workingDir;
    Configuration config;
    InodeTree<FileSystem> fsState;
    Path homeDir = null;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly; operation=" + operation + "Path=" + p);
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFileSystem.readOnlyMountTable(operation, p.toString());
    }

    private String getUriPath(Path p) {
        this.checkPath(p);
        return this.makeAbsolute(p).toUri().getPath();
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    public ViewFileSystem() throws IOException {
        this.creationTime = Time.now();
    }

    @Override
    public String getScheme() {
        return "viewfs";
    }

    @Override
    public void initialize(URI theUri, Configuration conf) throws IOException {
        super.initialize(theUri, conf);
        this.setConf(conf);
        this.config = conf;
        String authority = theUri.getAuthority();
        try {
            this.myUri = new URI("viewfs", authority, "/", null, null);
            this.fsState = new InodeTree<FileSystem>(conf, authority){

                @Override
                protected FileSystem getTargetFileSystem(URI uri) throws URISyntaxException, IOException {
                    return new ChRootedFileSystem(uri, ViewFileSystem.this.config);
                }

                @Override
                protected FileSystem getTargetFileSystem(InodeTree.INodeDir<FileSystem> dir) throws URISyntaxException {
                    return new InternalDirOfViewFs(dir, ViewFileSystem.this.creationTime, ViewFileSystem.this.ugi, ViewFileSystem.this.myUri);
                }

                @Override
                protected FileSystem getTargetFileSystem(URI[] mergeFsURIList) throws URISyntaxException, UnsupportedFileSystemException {
                    throw new UnsupportedFileSystemException("mergefs not implemented");
                }
            };
            this.workingDir = this.getHomeDirectory();
        }
        catch (URISyntaxException e) {
            throw new IOException("URISyntax exception: " + theUri);
        }
    }

    ViewFileSystem(URI theUri, Configuration conf) throws IOException {
        this();
        this.initialize(theUri, conf);
    }

    public ViewFileSystem(Configuration conf) throws IOException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    public Path getTrashCanLocation(Path f) throws FileNotFoundException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return res.isInternalDir() ? null : ((FileSystem)res.targetFileSystem).getHomeDirectory();
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public Path resolvePath(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((FileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = base.equals("/") ? this.makeQualified(new Path(base + this.ugi.getShortUserName())) : this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.getUriPath(new_dir);
        this.workingDir = this.makeAbsolute(new_dir);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).append(res.remainingPath, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).createNonRecursive(res.remainingPath, permission, flags, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).create(res.remainingPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }
        return ((FileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public boolean delete(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(fs.getPath()), true);
        return ((FileSystem)res.targetFileSystem).getFileBlockLocations(new ViewFsFileStatus(fs, res.remainingPath), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath);
    }

    private static FileStatus fixFileStatus(FileStatus orig, Path qualified) throws IOException {
        if ("file".equals(orig.getPath().toUri().getScheme())) {
            orig = ViewFileSystem.wrapLocalFileStatus(orig, qualified);
        }
        orig.setPath(qualified);
        return orig;
    }

    private static FileStatus wrapLocalFileStatus(FileStatus orig, Path qualified) {
        return orig instanceof LocatedFileStatus ? new ViewFsLocatedFileStatus((LocatedFileStatus)orig, qualified) : new ViewFsFileStatus(orig, qualified);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((FileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return ViewFileSystem.fixFileStatus(status, this.makeQualified(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).access(res.remainingPath, mode);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((FileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            int i = 0;
            for (FileStatus status : statusLst) {
                statusLst[i++] = ViewFileSystem.fixFileStatus(status, this.getChrootedPath(res, status, f));
            }
        }
        return statusLst;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f, PathFilter filter) throws FileNotFoundException, IOException {
        final InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        final RemoteIterator<LocatedFileStatus> statusIter = ((FileSystem)res.targetFileSystem).listLocatedStatus(res.remainingPath);
        if (res.isInternalDir()) {
            return statusIter;
        }
        return new RemoteIterator<LocatedFileStatus>(){

            @Override
            public boolean hasNext() throws IOException {
                return statusIter.hasNext();
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                LocatedFileStatus status = (LocatedFileStatus)statusIter.next();
                return (LocatedFileStatus)ViewFileSystem.fixFileStatus(status, ViewFileSystem.this.getChrootedPath(res, status, f));
            }
        };
    }

    private Path getChrootedPath(InodeTree.ResolveResult<FileSystem> res, FileStatus status, Path f) throws IOException {
        String suffix = ((ChRootedFileSystem)res.targetFileSystem).stripOutRoot(status.getPath());
        return this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix));
    }

    @Override
    public boolean mkdirs(Path dir, FsPermission permission) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath, permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        InodeTree.ResolveResult<FileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }
        InodeTree.ResolveResult<FileSystem> resDst = this.fsState.resolve(this.getUriPath(dst), false);
        if (resDst.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", dst);
        }
        if (resSrc.targetFileSystem != resDst.targetFileSystem) {
            throw new IOException("Renames across Mount points not supported");
        }
        return ((FileSystem)resSrc.targetFileSystem).rename(resSrc.remainingPath, resDst.remainingPath);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).truncate(res.remainingPath, newLength);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).modifyAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeDefaultAcl(res.remainingPath);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAcl(res.remainingPath);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setAcl(res.remainingPath, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getAclStatus(res.remainingPath);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setXAttr(res.remainingPath, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttr(res.remainingPath, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).listXAttrs(res.remainingPath);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeXAttr(res.remainingPath, name);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setVerifyChecksum(verifyChecksum);
        }
    }

    @Override
    public long getDefaultBlockSize() {
        throw new NotInMountpointException("getDefaultBlockSize");
    }

    @Override
    public short getDefaultReplication() {
        throw new NotInMountpointException("getDefaultReplication");
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        throw new NotInMountpointException("getServerDefaults");
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultBlockSize(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }
    }

    @Override
    public short getDefaultReplication(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultReplication(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getServerDefaults(res.remainingPath);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getContentSummary(res.remainingPath);
    }

    @Override
    public void setWriteChecksum(boolean writeChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setWriteChecksum(writeChecksum);
        }
    }

    @Override
    public FileSystem[] getChildFileSystems() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        HashSet<FileSystem> children = new HashSet<FileSystem>();
        for (InodeTree.MountPoint<FileSystem> mountPoint : mountPoints) {
            FileSystem targetFs = (FileSystem)mountPoint.target.targetFileSystem;
            children.addAll(Arrays.asList(targetFs.getChildFileSystems()));
        }
        return children.toArray(new FileSystem[0]);
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    static class InternalDirOfViewFs
    extends FileSystem {
        final InodeTree.INodeDir<FileSystem> theInternalDir;
        final long creationTime;
        final UserGroupInformation ugi;
        final URI myUri;

        public InternalDirOfViewFs(InodeTree.INodeDir<FileSystem> dir, long cTime, UserGroupInformation ugi, URI uri) throws URISyntaxException {
            this.myUri = uri;
            try {
                this.initialize(this.myUri, new Configuration());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot occur");
            }
            this.theInternalDir = dir;
            this.creationTime = cTime;
            this.ugi = ugi;
        }

        private static void checkPathIsSlash(Path f) throws IOException {
            if (f != InodeTree.SlashPath) {
                throw new IOException("Internal implementation error: expected file name to be /");
            }
        }

        @Override
        public URI getUri() {
            return this.myUri;
        }

        @Override
        public Path getWorkingDirectory() {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public void setWorkingDirectory(Path new_dir) {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("append", f);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws AccessControlException {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }

        @Override
        public boolean delete(Path f) throws AccessControlException, IOException {
            return this.delete(f, true);
        }

        @Override
        public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(fs.getPath());
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            return new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(this.theInternalDir.fullPath).makeQualified(this.myUri, ROOT_PATH));
        }

        @Override
        public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            FileStatus[] result = new FileStatus[this.theInternalDir.children.size()];
            int i = 0;
            for (Map.Entry iEntry : this.theInternalDir.children.entrySet()) {
                InodeTree.INode inode = iEntry.getValue();
                if (inode instanceof InodeTree.INodeLink) {
                    InodeTree.INodeLink link = (InodeTree.INodeLink)inode;
                    result[i++] = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getUserName(), this.ugi.getGroupNames()[0], link.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                    continue;
                }
                result[i++] = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public boolean mkdirs(Path dir, FsPermission permission) throws AccessControlException, FileAlreadyExistsException {
            if (this.theInternalDir.isRoot && dir == null) {
                throw new FileAlreadyExistsException("/ already exits");
            }
            if (this.theInternalDir.children.containsKey(dir.toString().substring(1))) {
                return true;
            }
            throw ViewFileSystem.readOnlyMountTable("mkdirs", dir);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public boolean rename(Path src, Path dst) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            InternalDirOfViewFs.checkPathIsSlash(dst);
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }

        @Override
        public boolean truncate(Path f, long newLength) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("truncate", f);
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setOwner", f);
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setPermission", f);
        }

        @Override
        public boolean setReplication(Path f, short replication) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setReplication", f);
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setTimes", f);
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) {
        }

        @Override
        public FsServerDefaults getServerDefaults(Path f) throws IOException {
            throw new NotInMountpointException(f, "getServerDefaults");
        }

        @Override
        public long getDefaultBlockSize(Path f) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }

        @Override
        public short getDefaultReplication(Path f) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }

        @Override
        public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("modifyAclEntries", path);
        }

        @Override
        public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeAclEntries", path);
        }

        @Override
        public void removeDefaultAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeDefaultAcl", path);
        }

        @Override
        public void removeAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeAcl", path);
        }

        @Override
        public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("setAcl", path);
        }

        @Override
        public AclStatus getAclStatus(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            return new AclStatus.Builder().owner(this.ugi.getUserName()).group(this.ugi.getGroupNames()[0]).addEntries(AclUtil.getMinimalAcl(Constants.PERMISSION_555)).stickyBit(false).build();
        }

        @Override
        public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("setXAttr", path);
        }

        @Override
        public byte[] getXAttr(Path path, String name) throws IOException {
            throw new NotInMountpointException(path, "getXAttr");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public List<String> listXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "listXAttrs");
        }

        @Override
        public void removeXAttr(Path path, String name) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeXAttr", path);
        }
    }

    public static class MountPoint {
        private Path src;
        private URI[] targets;

        MountPoint(Path srcPath, URI[] targetURIs) {
            this.src = srcPath;
            this.targets = targetURIs;
        }

        Path getSrc() {
            return this.src;
        }

        URI[] getTargets() {
            return this.targets;
        }
    }
}

