/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.http.FilterContainer;
import oadd.org.apache.hadoop.http.FilterInitializer;
import oadd.org.apache.hadoop.security.AuthenticationWithProxyUserFilter;
import oadd.org.apache.hadoop.security.SecurityUtil;

public class AuthenticationFilterInitializer
extends FilterInitializer {
    static final String PREFIX = "hadoop.http.authentication.";

    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = AuthenticationFilterInitializer.getFilterConfigMap(conf, PREFIX);
        container.addFilter("authentication", AuthenticationWithProxyUserFilter.class.getName(), filterConfig);
    }

    public static Map<String, String> getFilterConfigMap(Configuration conf, String prefix) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("cookie.path", "/");
        for (Map.Entry<String, String> entry : conf) {
            String name = entry.getKey();
            if (!name.startsWith(prefix)) continue;
            String value = conf.get(name);
            name = name.substring(prefix.length());
            filterConfig.put(name, value);
        }
        String bindAddress = conf.get("bind.address");
        String principal = (String)filterConfig.get("kerberos.principal");
        if (principal != null) {
            try {
                principal = SecurityUtil.getServerPrincipal(principal, bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            filterConfig.put("kerberos.principal", principal);
        }
        return filterConfig;
    }
}

