/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.util.concurrent.atomic.AtomicLong;
import oadd.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public abstract class SequentialNumber {
    private final AtomicLong currentValue;

    protected SequentialNumber(long initialValue) {
        this.currentValue = new AtomicLong(initialValue);
    }

    public long getCurrentValue() {
        return this.currentValue.get();
    }

    public void setCurrentValue(long value) {
        this.currentValue.set(value);
    }

    public long nextValue() {
        return this.currentValue.incrementAndGet();
    }

    public void skipTo(long newValue) throws IllegalStateException {
        long c;
        do {
            if (newValue >= (c = this.getCurrentValue())) continue;
            throw new IllegalStateException("Cannot skip to less than the current value (=" + c + "), where newValue=" + newValue);
        } while (!this.currentValue.compareAndSet(c, newValue));
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AtomicLong thatValue = ((SequentialNumber)that).currentValue;
        return this.currentValue.equals(thatValue);
    }

    public int hashCode() {
        long v = this.currentValue.get();
        return (int)v ^ (int)(v >>> 32);
    }
}

