/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import oadd.org.apache.zookeeper.server.ZooKeeperServer;
import oadd.org.apache.zookeeper.server.ZooKeeperServerBean;
import oadd.org.apache.zookeeper.server.quorum.Leader;
import oadd.org.apache.zookeeper.server.quorum.LeaderMXBean;
import oadd.org.apache.zookeeper.server.quorum.LearnerHandler;

public class LeaderBean
extends ZooKeeperServerBean
implements LeaderMXBean {
    private final Leader leader;

    public LeaderBean(Leader leader, ZooKeeperServer zks) {
        super(zks);
        this.leader = leader;
    }

    @Override
    public String getName() {
        return "Leader";
    }

    @Override
    public String getCurrentZxid() {
        return "0x" + Long.toHexString(this.zks.getZxid());
    }

    @Override
    public String followerInfo() {
        StringBuilder sb = new StringBuilder();
        for (LearnerHandler handler : this.leader.getLearners()) {
            sb.append(handler.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.leader.self.getElectionTimeTaken();
    }
}

