/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import oadd.org.apache.zookeeper.jmx.MBeanRegistry;
import oadd.org.apache.zookeeper.server.DataTreeBean;
import oadd.org.apache.zookeeper.server.FinalRequestProcessor;
import oadd.org.apache.zookeeper.server.PrepRequestProcessor;
import oadd.org.apache.zookeeper.server.ZKDatabase;
import oadd.org.apache.zookeeper.server.ZooKeeperServer;
import oadd.org.apache.zookeeper.server.ZooKeeperServerBean;
import oadd.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import oadd.org.apache.zookeeper.server.quorum.LocalPeerBean;
import oadd.org.apache.zookeeper.server.quorum.QuorumPeer;
import oadd.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import oadd.org.apache.zookeeper.server.quorum.ReadOnlyBean;
import oadd.org.apache.zookeeper.server.quorum.ReadOnlyRequestProcessor;

public class ReadOnlyZooKeeperServer
extends QuorumZooKeeperServer {
    private volatile boolean shutdown = false;

    ReadOnlyZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        PrepRequestProcessor prepProcessor = new PrepRequestProcessor(this, finalProcessor);
        prepProcessor.start();
        this.firstProcessor = new ReadOnlyRequestProcessor(this, prepProcessor);
        ((ReadOnlyRequestProcessor)this.firstProcessor).start();
    }

    @Override
    public synchronized void startup() {
        if (this.shutdown) {
            LOG.warn("Not starting Read-only server as startup follows shutdown!");
            return;
        }
        this.registerJMX(new ReadOnlyBean(this), this.self.jmxLocalPeerBean);
        super.startup();
        this.self.cnxnFactory.setZooKeeperServer(this);
        LOG.info("Read-only server started");
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void setState(ZooKeeperServer.State state) {
        this.state = state;
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(ZooKeeperServer zks) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "read-only";
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        this.shutdown = true;
        this.unregisterJMX(this);
        this.self.cnxnFactory.setZooKeeperServer(null);
        this.self.cnxnFactory.closeAll();
        super.shutdown();
    }
}

