/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.response;

import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.api.mounts.Mount;
import com.bettercloud.vault.api.mounts.MountConfig;
import com.bettercloud.vault.api.mounts.MountType;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.json.JsonValue;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.rest.RestResponse;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class MountResponse
extends LogicalResponse {
    private static final long serialVersionUID = -7066405243425032451L;
    private final Mount mount;
    private final Map<String, Mount> mounts;

    public MountResponse(RestResponse restResponse, int retries, boolean isList) {
        super(restResponse, retries, Logical.logicalOperations.mount);
        this.mount = isList ? null : this.buildMount(this.getDataObject());
        this.mounts = isList ? this.buildMountsMap() : null;
    }

    public Mount getMount() {
        return this.mount;
    }

    public Map<String, Mount> getMounts() {
        return this.mounts;
    }

    private Mount buildMount(JsonObject data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        MountType type = MountType.of(data.getString("type"));
        String description = data.getString("description");
        MountConfig config = this.buildMountConfig(data);
        Boolean local = data.getBoolean("local");
        Boolean sealWrap = data.getBoolean("seal_wrap");
        if (type == null && description == null && config == null && local == null && sealWrap == null) {
            return null;
        }
        return new Mount().type(type).description(description).config(config).local(local).sealWrap(sealWrap);
    }

    private MountConfig buildMountConfig(JsonObject data) {
        JsonObject config;
        if (data == null || data.isEmpty()) {
            return null;
        }
        JsonValue object = data.get("config");
        JsonObject jsonObject = config = object != null ? object.asObject() : data;
        if (config == null || config.isEmpty()) {
            return null;
        }
        Integer defaultLeaseTtl = config.getInt("default_lease_ttl");
        Integer maxLeaseTtl = config.getInt("max_lease_ttl");
        String description = config.getString("description");
        Boolean forceNoCache = config.getBoolean("force_no_cache");
        String pluginName = config.getString("plugin_name");
        if (defaultLeaseTtl == null && maxLeaseTtl == null && description == null && forceNoCache == null && pluginName == null) {
            return null;
        }
        return new MountConfig().defaultLeaseTtl(defaultLeaseTtl).maxLeaseTtl(maxLeaseTtl).description(description).forceNoCache(forceNoCache).pluginName(pluginName);
    }

    private Map<String, Mount> buildMountsMap() {
        JsonObject data = this.getDataObject();
        if (data == null || data.isEmpty()) {
            return Collections.emptyMap();
        }
        return StreamSupport.stream(data.spliterator(), false).collect(Collectors.toMap(JsonObject.Member::getName, member -> this.buildMount(member.getValue().asObject())));
    }
}

