/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.google.common.collect;

import java.util.Spliterator;
import java.util.function.Consumer;
import oadd.com.google.common.annotations.GwtCompatible;
import oadd.com.google.common.annotations.GwtIncompatible;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.CollectSpliterators;
import oadd.com.google.common.collect.ImmutableAsList;
import oadd.com.google.common.collect.ImmutableCollection;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.ImmutableSet;
import oadd.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(emulated=true)
abstract class IndexedImmutableSet<E>
extends ImmutableSet<E> {
    IndexedImmutableSet() {
    }

    abstract E get(int var1);

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1297, this::get);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        return this.asList().copyIntoArray(dst, offset);
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableAsList<E>(){

            @Override
            public E get(int index) {
                return IndexedImmutableSet.this.get(index);
            }

            @Override
            boolean isPartialView() {
                return IndexedImmutableSet.this.isPartialView();
            }

            @Override
            public int size() {
                return IndexedImmutableSet.this.size();
            }

            @Override
            ImmutableCollection<E> delegateCollection() {
                return IndexedImmutableSet.this;
            }
        };
    }
}

