/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.typesafe.config.impl;

import oadd.com.typesafe.config.ConfigValueType;
import oadd.com.typesafe.config.impl.AbstractConfigValue;
import oadd.com.typesafe.config.impl.ConfigBoolean;
import oadd.com.typesafe.config.impl.ConfigDouble;
import oadd.com.typesafe.config.impl.ConfigLong;
import oadd.com.typesafe.config.impl.ConfigNull;
import oadd.com.typesafe.config.impl.ConfigString;

final class DefaultTransformer {
    DefaultTransformer() {
    }

    static AbstractConfigValue transform(AbstractConfigValue abstractConfigValue, ConfigValueType configValueType) {
        if (abstractConfigValue.valueType() == ConfigValueType.STRING) {
            String string = (String)abstractConfigValue.unwrapped();
            switch (configValueType) {
                case NUMBER: {
                    try {
                        Long l = Long.parseLong(string);
                        return new ConfigLong(abstractConfigValue.origin(), l, string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            Double d = Double.parseDouble(string);
                            return new ConfigDouble(abstractConfigValue.origin(), d, string);
                        }
                        catch (NumberFormatException numberFormatException2) {
                            break;
                        }
                    }
                }
                case NULL: {
                    if (!string.equals("null")) break;
                    return new ConfigNull(abstractConfigValue.origin());
                }
                case BOOLEAN: {
                    if (string.equals("true") || string.equals("yes") || string.equals("on")) {
                        return new ConfigBoolean(abstractConfigValue.origin(), true);
                    }
                    if (!string.equals("false") && !string.equals("no") && !string.equals("off")) break;
                    return new ConfigBoolean(abstractConfigValue.origin(), false);
                }
                case LIST: {
                    break;
                }
                case OBJECT: {
                    break;
                }
            }
        } else if (configValueType == ConfigValueType.STRING) {
            switch (abstractConfigValue.valueType()) {
                case NUMBER: 
                case BOOLEAN: {
                    return new ConfigString(abstractConfigValue.origin(), abstractConfigValue.transformToString());
                }
                case NULL: {
                    break;
                }
                case OBJECT: {
                    break;
                }
                case LIST: {
                    break;
                }
            }
        }
        return abstractConfigValue;
    }
}

