/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.common.graph.GraphVisitor;
import oadd.org.apache.drill.common.logical.ValidationError;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;

public abstract class LogicalOperatorBase
implements LogicalOperator {
    private final List<LogicalOperator> children = new ArrayList<LogicalOperator>();
    private String memo;

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public void setupAndValidate(List<LogicalOperator> operators, Collection<ValidationError> errors) {
    }

    @Override
    public LogicalOperator.NodeBuilder<?> nodeBuilder() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void accept(GraphVisitor<LogicalOperator> visitor) {
        if (visitor.enter(this)) {
            visitor.leave(this);
        }
    }

    @Override
    public void registerAsSubscriber(LogicalOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("You attempted to register a null operators.");
        }
        this.children.add(operator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [memo=" + this.memo + "]";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="memo")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}

