/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.store.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import oadd.org.apache.drill.exec.exception.MetadataException;
import oadd.org.apache.drill.exec.metastore.MetastoreMetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.store.MetastoreFileTableMetadataProvider;
import oadd.org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProvider;
import oadd.org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProvider;
import oadd.org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProviderBuilder;
import oadd.org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProviderImpl;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.store.dfs.FileSelection;
import oadd.org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import oadd.org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import oadd.org.apache.drill.exec.util.DrillFileSystemUtil;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathFilter;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.shaded.guava.com.google.common.collect.LinkedListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;

public class MetastoreParquetTableMetadataProvider
extends MetastoreFileTableMetadataProvider
implements ParquetTableMetadataProvider {
    private final List<ReadEntryWithPath> entries;
    private final ParquetTableMetadataProviderBuilder<?> fallbackBuilder;
    private Multimap<Path, RowGroupMetadata> rowGroups;
    private ParquetMetadataProvider fallback;

    private MetastoreParquetTableMetadataProvider(Builder builder) {
        super(builder);
        this.entries = builder.entries;
        this.fallbackBuilder = builder.fallback;
        ParquetTableMetadataProvider source = (ParquetTableMetadataProvider)builder.metadataProviderManager().getTableMetadataProvider();
        if (source == null || source.getRowGroupsMeta().size() < this.getRowGroupsMeta().size()) {
            builder.metadataProviderManager().setTableMetadataProvider(this);
        }
    }

    @Override
    public boolean isUsedMetadataCache() {
        return false;
    }

    @Override
    public Path getSelectionRoot() {
        return this.getTableMetadata().getLocation();
    }

    @Override
    public List<ReadEntryWithPath> getEntries() {
        return this.entries;
    }

    @Override
    public List<RowGroupMetadata> getRowGroupsMeta() {
        return new ArrayList<RowGroupMetadata>(this.getRowGroupsMetadataMap().values());
    }

    @Override
    public List<Path> getLocations() {
        return new ArrayList<Path>(this.getFilesMetadataMap().keySet());
    }

    @Override
    public Multimap<Path, RowGroupMetadata> getRowGroupsMetadataMap() {
        this.throwIfChanged();
        if (this.rowGroups == null) {
            this.rowGroups = LinkedListMultimap.create();
            this.basicTablesRequests.rowGroupsMetadata(this.tableInfo, null, this.paths).stream().collect(Collectors.groupingBy(RowGroupMetadata::getPath, Collectors.toList())).forEach((path, rowGroupMetadata) -> this.rowGroups.putAll((Path)path, (Iterable<RowGroupMetadata>)rowGroupMetadata));
            if (this.rowGroups.isEmpty()) {
                if (this.fallbackToFileMetadata) {
                    try {
                        this.rowGroups = this.getFallbackTableMetadataProvider().getRowGroupsMetadataMap();
                    }
                    catch (IOException e) {
                        throw MetadataException.of(MetadataException.MetadataExceptionType.FALLBACK_EXCEPTION, e);
                    }
                } else {
                    throw MetadataException.of(MetadataException.MetadataExceptionType.INCOMPLETE_METADATA);
                }
            }
        }
        return this.rowGroups;
    }

    @Override
    public Set<Path> getFileSet() {
        this.throwIfChanged();
        return this.getFilesMetadataMap().keySet();
    }

    private ParquetMetadataProvider getFallbackTableMetadataProvider() throws IOException {
        if (this.fallback == null) {
            this.fallback = this.fallbackBuilder == null ? null : this.fallbackBuilder.build();
        }
        return this.fallback;
    }

    public static class Builder
    extends MetastoreFileTableMetadataProvider.Builder<Builder>
    implements ParquetTableMetadataProviderBuilder<Builder> {
        private final ParquetTableMetadataProviderBuilder<?> fallback;
        private List<ReadEntryWithPath> entries;

        public Builder(MetastoreMetadataProviderManager source) {
            super(source, new ParquetTableMetadataProviderImpl.Builder(FileSystemMetadataProviderManager.init()));
            this.fallback = (ParquetTableMetadataProviderBuilder)((MetastoreFileTableMetadataProvider.Builder)this).fallback;
        }

        @Override
        public Builder withEntries(List<ReadEntryWithPath> entries) {
            this.entries = entries;
            this.fallback.withEntries(entries);
            return this;
        }

        @Override
        public Builder withSelectionRoot(Path selectionRoot) {
            this.fallback.withSelectionRoot(selectionRoot);
            return this;
        }

        @Override
        public Builder withCacheFileRoot(Path cacheFileRoot) {
            this.fallback.withCacheFileRoot(cacheFileRoot);
            return this;
        }

        @Override
        public Builder withReaderConfig(ParquetReaderConfig readerConfig) {
            this.fallback.withReaderConfig(readerConfig);
            return this;
        }

        @Override
        public Builder withFileSystem(DrillFileSystem fs) {
            this.fallback.withFileSystem(fs);
            return (Builder)super.withFileSystem(fs);
        }

        @Override
        public Builder withCorrectCorruptedDates(boolean autoCorrectCorruptedDates) {
            this.fallback.withCorrectCorruptedDates(autoCorrectCorruptedDates);
            return this;
        }

        @Override
        public Builder withSelection(FileSelection selection) {
            this.fallback.withSelection(selection);
            return (Builder)super.withSelection(selection);
        }

        @Override
        public Builder withSchema(TupleMetadata schema) {
            this.fallback.withSchema(schema);
            return (Builder)super.withSchema(schema);
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public ParquetTableMetadataProvider build() throws IOException {
            if (this.entries == null) {
                this.entries = !this.selection().isExpandedFully() ? DrillFileSystemUtil.listFiles((FileSystem)this.fs(), this.selection().getSelectionRoot(), true, new PathFilter[0]).stream().map(fileStatus -> new ReadEntryWithPath(Path.getPathWithoutSchemeAndAuthority(fileStatus.getPath()))).collect(Collectors.toList()) : this.selection().getFiles().stream().map(Path::getPathWithoutSchemeAndAuthority).map(ReadEntryWithPath::new).collect(Collectors.toList());
            }
            this.paths = this.entries.stream().map(readEntryWithPath -> readEntryWithPath.getPath().toUri().getPath()).collect(Collectors.toList());
            return new MetastoreParquetTableMetadataProvider(this);
        }
    }
}

