/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.FieldIdUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(SimpleVectorWrapper.class);
    private T vector;

    public SimpleVectorWrapper(T v) {
        this.vector = v;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.vector.getClass();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public T getValueVector() {
        return this.vector;
    }

    @Override
    public T[] getValueVectors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyper() {
        return false;
    }

    @Override
    public VectorWrapper<T> cloneAndTransfer(BufferAllocator allocator) {
        TransferPair tp = this.vector.getTransferPair(allocator);
        tp.transfer();
        return new SimpleVectorWrapper<ValueVector>(tp.getTo());
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    public static <T extends ValueVector> SimpleVectorWrapper<T> create(T v) {
        return new SimpleVectorWrapper<T>(v);
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        Object vector = this.vector;
        for (int i = 1; i < ids.length; ++i) {
            AbstractMapVector mapLike = (AbstractMapVector)AbstractMapVector.class.cast(vector);
            if (mapLike == null) {
                return null;
            }
            vector = mapLike.getChildByOrdinal(ids[i]);
        }
        return new SimpleVectorWrapper<T>(vector);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, SchemaPath expectedPath) {
        return FieldIdUtil.getFieldId(this.getValueVector(), id, expectedPath, false);
    }

    @Override
    public void transfer(VectorWrapper<?> destination) {
        Preconditions.checkArgument(destination instanceof SimpleVectorWrapper);
        Preconditions.checkArgument(this.getField().getType().equals(destination.getField().getType()));
        this.vector.makeTransferPair((ValueVector)((SimpleVectorWrapper)destination).vector).transfer();
    }

    public String toString() {
        if (this.vector == null) {
            return "null";
        }
        return this.vector.toString();
    }
}

