/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata.schema.parser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oadd.org.antlr.v4.runtime.tree.TerminalNode;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.DictBuilder;
import oadd.org.apache.drill.exec.record.metadata.MapBuilder;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;
import oadd.org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaParser;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaParserBaseVisitor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class SchemaVisitor
extends SchemaParserBaseVisitor<TupleMetadata> {
    @Override
    public TupleMetadata visitSchema(SchemaParser.SchemaContext ctx) {
        TupleMetadata schema;
        TupleMetadata tupleMetadata = schema = ctx.columns() == null ? new TupleSchema() : this.visitColumns(ctx.columns());
        if (ctx.property_values() != null) {
            PropertiesVisitor propertiesVisitor = new PropertiesVisitor();
            schema.setProperties(ctx.property_values().accept(propertiesVisitor));
        }
        return schema;
    }

    @Override
    public TupleMetadata visitColumns(SchemaParser.ColumnsContext ctx) {
        TupleSchema schema = new TupleSchema();
        ColumnDefVisitor columnDefVisitor = new ColumnDefVisitor();
        ctx.column_def().forEach(columnDef -> schema.addColumn(columnDef.accept(columnDefVisitor)));
        return schema;
    }

    public static class PropertiesVisitor
    extends SchemaParserBaseVisitor<Map<String, String>> {
        @Override
        public Map<String, String> visitProperty_values(SchemaParser.Property_valuesContext ctx) {
            StringValueVisitor stringValueVisitor = new StringValueVisitor();
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            ctx.property_pair().forEach(pair -> {
                List pairValues = pair.string_value().stream().map(stringValueVisitor::visit).collect(Collectors.toList());
                Preconditions.checkState(pairValues.size() == 2);
                properties.put((String)pairValues.get(0), (String)pairValues.get(1));
            });
            return properties;
        }
    }

    private static class SimpleArrayValueTypeVisitor
    extends SchemaParserBaseVisitor<ColumnMetadata> {
        private final String name;
        private final TypeVisitor typeVisitor;

        SimpleArrayValueTypeVisitor(String name) {
            this.name = name;
            this.typeVisitor = new TypeVisitor(name, TypeProtos.DataMode.REPEATED);
        }

        @Override
        public ColumnMetadata visitArray_simple_type_def(SchemaParser.Array_simple_type_defContext ctx) {
            return ctx.simple_type().accept(this.typeVisitor);
        }

        @Override
        public ColumnMetadata visitArray_struct_type_def(SchemaParser.Array_struct_type_defContext ctx) {
            return ctx.struct_type().accept(this.typeVisitor);
        }

        @Override
        public ColumnMetadata visitArray_map_type_def(SchemaParser.Array_map_type_defContext ctx) {
            return ctx.map_type().accept(this.typeVisitor);
        }

        @Override
        public ColumnMetadata visitArray_union_type_def(SchemaParser.Array_union_type_defContext ctx) {
            return VariantColumnMetadata.list(this.name);
        }
    }

    private static class ArrayTypeVisitor
    extends SchemaParserBaseVisitor<ColumnMetadata> {
        private final String name;

        ArrayTypeVisitor(String name) {
            this.name = name;
        }

        @Override
        public ColumnMetadata visitSimple_array_type(SchemaParser.Simple_array_typeContext ctx) {
            SimpleArrayValueTypeVisitor visitor = new SimpleArrayValueTypeVisitor(this.name);
            return ctx.simple_array_value_type().accept(visitor);
        }

        @Override
        public ColumnMetadata visitComplex_array_type(SchemaParser.Complex_array_typeContext ctx) {
            RepeatedListBuilder childBuilder = new RepeatedListBuilder(null, this.name);
            ColumnMetadata child = ctx.array_type().accept(new ArrayTypeVisitor(this.name));
            childBuilder.addColumn(child);
            return childBuilder.buildColumn();
        }
    }

    private static class MapValueTypeVisitor
    extends SchemaParserBaseVisitor<ColumnMetadata> {
        private final TypeProtos.DataMode mode;

        MapValueTypeVisitor(TypeProtos.DataMode mode) {
            this.mode = mode;
        }

        @Override
        public ColumnMetadata visitMap_value_simple_type_def(SchemaParser.Map_value_simple_type_defContext ctx) {
            return ctx.simple_type().accept(new TypeVisitor("value", this.mode));
        }

        @Override
        public ColumnMetadata visitMap_value_struct_type_def(SchemaParser.Map_value_struct_type_defContext ctx) {
            TypeProtos.DataMode structMode = TypeProtos.DataMode.REPEATED == this.mode ? this.mode : TypeProtos.DataMode.REQUIRED;
            return ctx.struct_type().accept(new TypeVisitor("value", structMode));
        }

        @Override
        public ColumnMetadata visitMap_value_map_type_def(SchemaParser.Map_value_map_type_defContext ctx) {
            TypeProtos.DataMode mapMode = TypeProtos.DataMode.REPEATED == this.mode ? this.mode : TypeProtos.DataMode.REQUIRED;
            return ctx.map_type().accept(new TypeVisitor("value", mapMode));
        }

        @Override
        public ColumnMetadata visitMap_value_array_type_def(SchemaParser.Map_value_array_type_defContext ctx) {
            return ctx.array_type().accept(new ArrayTypeVisitor("value"));
        }

        @Override
        public ColumnMetadata visitMap_value_union_type_def(SchemaParser.Map_value_union_type_defContext ctx) {
            return VariantColumnMetadata.union("value");
        }
    }

    private static class MapKeyTypeVisitor
    extends SchemaParserBaseVisitor<TypeProtos.MajorType> {
        private static final TypeVisitor KEY_VISITOR = new TypeVisitor("key", TypeProtos.DataMode.REQUIRED);
        static final MapKeyTypeVisitor INSTANCE = new MapKeyTypeVisitor();

        private MapKeyTypeVisitor() {
        }

        @Override
        public TypeProtos.MajorType visitMap_key_simple_type_def(SchemaParser.Map_key_simple_type_defContext ctx) {
            return ctx.simple_type().accept(KEY_VISITOR).majorType();
        }
    }

    private static class TypeVisitor
    extends SchemaParserBaseVisitor<ColumnMetadata> {
        private final String name;
        private final TypeProtos.DataMode mode;

        TypeVisitor(String name, TypeProtos.DataMode mode) {
            this.name = name;
            this.mode = mode;
        }

        @Override
        public ColumnMetadata visitInt(SchemaParser.IntContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.INT, this.mode));
        }

        @Override
        public ColumnMetadata visitBigint(SchemaParser.BigintContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.BIGINT, this.mode));
        }

        @Override
        public ColumnMetadata visitFloat(SchemaParser.FloatContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.FLOAT4, this.mode));
        }

        @Override
        public ColumnMetadata visitDouble(SchemaParser.DoubleContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.FLOAT8, this.mode));
        }

        @Override
        public ColumnMetadata visitDecimal(SchemaParser.DecimalContext ctx) {
            TypeProtos.MajorType type = Types.withMode(TypeProtos.MinorType.VARDECIMAL, this.mode);
            List<TerminalNode> numbers = ctx.NUMBER();
            if (!numbers.isEmpty()) {
                int precision = Integer.parseInt(numbers.get(0).getText());
                int scale = numbers.size() == 2 ? Integer.parseInt(numbers.get(1).getText()) : 0;
                type = type.toBuilder().setPrecision(precision).setScale(scale).build();
            }
            return this.constructColumn(type);
        }

        @Override
        public ColumnMetadata visitBoolean(SchemaParser.BooleanContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.BIT, this.mode));
        }

        @Override
        public ColumnMetadata visitVarchar(SchemaParser.VarcharContext ctx) {
            TypeProtos.MajorType type = Types.withMode(TypeProtos.MinorType.VARCHAR, this.mode);
            if (ctx.NUMBER() != null) {
                type = type.toBuilder().setPrecision(Integer.parseInt(ctx.NUMBER().getText())).build();
            }
            return this.constructColumn(type);
        }

        @Override
        public ColumnMetadata visitBinary(SchemaParser.BinaryContext ctx) {
            TypeProtos.MajorType type = Types.withMode(TypeProtos.MinorType.VARBINARY, this.mode);
            if (ctx.NUMBER() != null) {
                type = type.toBuilder().setPrecision(Integer.parseInt(ctx.NUMBER().getText())).build();
            }
            return this.constructColumn(type);
        }

        @Override
        public ColumnMetadata visitTime(SchemaParser.TimeContext ctx) {
            TypeProtos.MajorType type = Types.withMode(TypeProtos.MinorType.TIME, this.mode);
            if (ctx.NUMBER() != null) {
                type = type.toBuilder().setPrecision(Integer.parseInt(ctx.NUMBER().getText())).build();
            }
            return this.constructColumn(type);
        }

        @Override
        public ColumnMetadata visitDate(SchemaParser.DateContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.DATE, this.mode));
        }

        @Override
        public ColumnMetadata visitTimestamp(SchemaParser.TimestampContext ctx) {
            TypeProtos.MajorType type = Types.withMode(TypeProtos.MinorType.TIMESTAMP, this.mode);
            if (ctx.NUMBER() != null) {
                type = type.toBuilder().setPrecision(Integer.parseInt(ctx.NUMBER().getText())).build();
            }
            return this.constructColumn(type);
        }

        @Override
        public ColumnMetadata visitInterval_year(SchemaParser.Interval_yearContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.INTERVALYEAR, this.mode));
        }

        @Override
        public ColumnMetadata visitInterval_day(SchemaParser.Interval_dayContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.INTERVALDAY, this.mode));
        }

        @Override
        public ColumnMetadata visitInterval(SchemaParser.IntervalContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.INTERVAL, this.mode));
        }

        @Override
        public ColumnMetadata visitUnit1(SchemaParser.Unit1Context ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.UINT1, this.mode));
        }

        @Override
        public ColumnMetadata visitUnit2(SchemaParser.Unit2Context ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.UINT2, this.mode));
        }

        @Override
        public ColumnMetadata visitUnit4(SchemaParser.Unit4Context ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.UINT4, this.mode));
        }

        @Override
        public ColumnMetadata visitUnit8(SchemaParser.Unit8Context ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.UINT8, this.mode));
        }

        @Override
        public ColumnMetadata visitTinyint(SchemaParser.TinyintContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.TINYINT, this.mode));
        }

        @Override
        public ColumnMetadata visitSmallint(SchemaParser.SmallintContext ctx) {
            return this.constructColumn(Types.withMode(TypeProtos.MinorType.SMALLINT, this.mode));
        }

        @Override
        public ColumnMetadata visitDynamic(SchemaParser.DynamicContext ctx) {
            return MetadataUtils.newDynamic(this.name);
        }

        @Override
        public ColumnMetadata visitStruct_type(SchemaParser.Struct_typeContext ctx) {
            MapBuilder builder = new MapBuilder(null, this.name, this.mode);
            ColumnDefVisitor visitor = new ColumnDefVisitor();
            ctx.columns().column_def().forEach(c -> builder.addColumn(c.accept(visitor)));
            return builder.buildColumn();
        }

        @Override
        public ColumnMetadata visitMap_type(SchemaParser.Map_typeContext ctx) {
            DictBuilder builder = new DictBuilder(null, this.name, this.mode);
            builder.key(ctx.map_key_type_def().map_key_type().accept(MapKeyTypeVisitor.INSTANCE));
            SchemaParser.Map_value_type_defContext valueDef = ctx.map_value_type_def();
            TypeProtos.DataMode valueMode = valueDef.nullability() == null ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED;
            builder.addColumn(valueDef.map_value_type().accept(new MapValueTypeVisitor(valueMode)));
            return builder.buildColumn();
        }

        private ColumnMetadata constructColumn(TypeProtos.MajorType type) {
            MaterializedField field = MaterializedField.create(this.name, type);
            return MetadataUtils.fromField(field);
        }
    }

    private static class IdVisitor
    extends SchemaParserBaseVisitor<String> {
        private IdVisitor() {
        }

        @Override
        public String visitId(SchemaParser.IdContext ctx) {
            return ctx.ID().getText();
        }

        @Override
        public String visitQuoted_id(SchemaParser.Quoted_idContext ctx) {
            String text = ctx.QUOTED_ID().getText();
            return text.substring(1, text.length() - 1).replaceAll("\\\\(.)", "$1");
        }
    }

    private static class StringValueVisitor
    extends SchemaParserBaseVisitor<String> {
        private StringValueVisitor() {
        }

        @Override
        public String visitString_value(SchemaParser.String_valueContext ctx) {
            String text = ctx.getText();
            return text.substring(1, text.length() - 1).replaceAll("\\\\(.)", "$1");
        }
    }

    public static class ColumnVisitor
    extends SchemaParserBaseVisitor<ColumnMetadata> {
        @Override
        public ColumnMetadata visitPrimitive_column(SchemaParser.Primitive_columnContext ctx) {
            String name = ctx.column_id().accept(new IdVisitor());
            TypeProtos.DataMode mode = ctx.nullability() == null ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED;
            ColumnMetadata columnMetadata = ctx.simple_type().accept(new TypeVisitor(name, mode));
            StringValueVisitor stringValueVisitor = new StringValueVisitor();
            if (ctx.format_value() != null) {
                columnMetadata.setFormat((String)stringValueVisitor.visit(ctx.format_value().string_value()));
            }
            if (ctx.default_value() != null) {
                columnMetadata.setDefaultValue((String)stringValueVisitor.visit(ctx.default_value().string_value()));
            }
            return columnMetadata;
        }

        @Override
        public ColumnMetadata visitSimple_array_column(SchemaParser.Simple_array_columnContext ctx) {
            String name = ctx.column_id().accept(new IdVisitor());
            return ctx.simple_array_type().accept(new ArrayTypeVisitor(name));
        }

        @Override
        public ColumnMetadata visitStruct_column(SchemaParser.Struct_columnContext ctx) {
            String name = ctx.column_id().accept(new IdVisitor());
            return ctx.struct_type().accept(new TypeVisitor(name, TypeProtos.DataMode.REQUIRED));
        }

        @Override
        public ColumnMetadata visitMap_column(SchemaParser.Map_columnContext ctx) {
            String name = ctx.column_id().accept(new IdVisitor());
            return ctx.map_type().accept(new TypeVisitor(name, TypeProtos.DataMode.REQUIRED));
        }

        @Override
        public ColumnMetadata visitComplex_array_column(SchemaParser.Complex_array_columnContext ctx) {
            String name = ctx.column_id().accept(new IdVisitor());
            ColumnMetadata child = ctx.complex_array_type().array_type().accept(new ArrayTypeVisitor(name));
            RepeatedListBuilder builder = new RepeatedListBuilder(null, name);
            builder.addColumn(child);
            return builder.buildColumn();
        }

        @Override
        public ColumnMetadata visitUnion_column(SchemaParser.Union_columnContext ctx) {
            String name = ctx.column_id().accept(new IdVisitor());
            return VariantColumnMetadata.union(name);
        }
    }

    public static class ColumnDefVisitor
    extends SchemaParserBaseVisitor<ColumnMetadata> {
        @Override
        public ColumnMetadata visitColumn_def(SchemaParser.Column_defContext ctx) {
            ColumnVisitor columnVisitor = new ColumnVisitor();
            ColumnMetadata columnMetadata = ctx.column().accept(columnVisitor);
            if (ctx.property_values() != null) {
                PropertiesVisitor propertiesVisitor = new PropertiesVisitor();
                columnMetadata.setProperties(ctx.property_values().accept(propertiesVisitor));
            }
            return columnMetadata;
        }
    }
}

