/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.time.LocalDateTime;
import java.util.ArrayList;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.util.DrillStringUtils;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.joda.time.DateTime;
import oadd.org.joda.time.format.DateTimeFormat;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorUtil {
    private static final Logger logger = LoggerFactory.getLogger(VectorUtil.class);
    public static final int DEFAULT_COLUMN_WIDTH = 15;

    public static void logVectorAccessibleContent(VectorAccessible va, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int rows = va.getRecordCount();
        sb.append(rows).append(" row(s):\n");
        ArrayList<String> columns = Lists.newArrayList();
        for (Object vw : va) {
            columns.add(VectorUtil.formatFieldSchema(vw.getValueVector().getField()));
        }
        int width = columns.size();
        for (String column : columns) {
            sb.append(column).append(column.equals(columns.get(width - 1)) ? "\n" : delimiter);
        }
        for (int row = 0; row < rows; ++row) {
            int columnCounter = 0;
            for (VectorWrapper vw : va) {
                String value;
                Object o;
                boolean lastColumn = columnCounter == width - 1;
                try {
                    o = vw.getValueVector().getAccessor().getObject(row);
                }
                catch (Exception e) {
                    throw new RuntimeException("failure while trying to read column " + vw.getField().getName());
                }
                if (o == null) {
                    value = "null";
                    sb.append(value).append(lastColumn ? "\n" : delimiter);
                } else if (o instanceof byte[]) {
                    value = new String((byte[])o);
                    sb.append(value).append(lastColumn ? "\n" : delimiter);
                } else {
                    value = o.toString();
                    sb.append(value).append(lastColumn ? "\n" : delimiter);
                }
                ++columnCounter;
            }
        }
        for (VectorWrapper vw : va) {
            vw.clear();
        }
        logger.info(sb.toString());
    }

    public static String formatFieldSchema(MaterializedField field) {
        String colName = field.getName() + "<" + field.getType().getMinorType() + "(" + field.getType().getMode() + ")>";
        if (field.getType().getMinorType() == TypeProtos.MinorType.MAP) {
            colName = colName + VectorUtil.expandMapSchema(field);
        }
        return colName;
    }

    public static void appendVectorAccessibleContent(VectorAccessible va, StringBuilder formattedResults, String delimiter, boolean includeHeader) {
        if (includeHeader) {
            ArrayList<String> columns = Lists.newArrayList();
            for (VectorWrapper vw : va) {
                columns.add(vw.getValueVector().getField().getName());
            }
            formattedResults.append(Joiner.on(delimiter).join(columns));
            formattedResults.append("\n");
        }
        int rows = va.getRecordCount();
        for (int row = 0; row < rows; ++row) {
            ArrayList<String> rowValues = Lists.newArrayList();
            for (VectorWrapper vw : va) {
                Object o = vw.getValueVector().getAccessor().getObject(row);
                if (o == null) {
                    rowValues.add("null");
                    continue;
                }
                if (o instanceof byte[]) {
                    rowValues.add(new String((byte[])o));
                    continue;
                }
                if (o instanceof DateTime) {
                    rowValues.add(DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print((DateTime)o));
                    continue;
                }
                if (o instanceof LocalDateTime) {
                    rowValues.add(DateUtility.formatTimeStamp.format((LocalDateTime)o));
                    continue;
                }
                rowValues.add(o.toString());
            }
            formattedResults.append(Joiner.on(delimiter).join(rowValues));
            formattedResults.append("\n");
        }
        for (VectorWrapper vw : va) {
            vw.clear();
        }
    }

    public static void logVectorAccessibleContent(VectorAccessible va) {
        VectorUtil.logVectorAccessibleContent(va, 15);
    }

    public static void logVectorAccessibleContent(VectorAccessible va, int columnWidth) {
        VectorUtil.logVectorAccessibleContent(va, new int[]{columnWidth});
    }

    public static void logVectorAccessibleContent(VectorAccessible va, int[] columnWidths) {
        StringBuilder sb = new StringBuilder();
        int width = 0;
        int columnIndex = 0;
        ArrayList<String> columns = Lists.newArrayList();
        ArrayList<String> formats = Lists.newArrayList();
        for (VectorWrapper vw : va) {
            int columnWidth = VectorUtil.getColumnWidth(columnWidths, columnIndex);
            width += columnWidth + 2;
            formats.add("| %-" + columnWidth + "s");
            ++columnIndex;
            columns.add(VectorUtil.formatFieldSchema(vw.getValueVector().getField()));
        }
        int rows = va.getRecordCount();
        sb.append(rows).append(" row(s):\n");
        for (int row = 0; row < rows; ++row) {
            int columnWidth;
            if (row % 50 == 0) {
                sb.append(StringUtils.repeat("-", width + 1)).append('\n');
                columnIndex = 0;
                for (String column : columns) {
                    columnWidth = VectorUtil.getColumnWidth(columnWidths, columnIndex);
                    sb.append(String.format((String)formats.get(columnIndex), column.length() <= columnWidth ? column : column.substring(0, columnWidth - 1)));
                    ++columnIndex;
                }
                sb.append("|\n");
                sb.append(StringUtils.repeat("-", width + 1)).append('\n');
            }
            columnIndex = 0;
            for (VectorWrapper vw : va) {
                columnWidth = VectorUtil.getColumnWidth(columnWidths, columnIndex);
                Object o = vw.getValueVector().getAccessor().getObject(row);
                String cellString = o instanceof byte[] ? DrillStringUtils.toBinaryString((byte[])o) : DrillStringUtils.escapeNewLines(String.valueOf(o));
                sb.append(String.format((String)formats.get(columnIndex), cellString.length() <= columnWidth ? cellString : cellString.substring(0, columnWidth - 1)));
                ++columnIndex;
            }
            sb.append("|\n");
        }
        if (rows > 0) {
            sb.append(StringUtils.repeat("-", width + 1)).append('\n');
        }
        for (VectorWrapper vw : va) {
            vw.clear();
        }
        logger.info(sb.toString());
    }

    private static String expandMapSchema(MaterializedField mapField) {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        String sep = "";
        for (MaterializedField field : mapField.getChildren()) {
            buf.append(sep);
            sep = ",";
            buf.append(VectorUtil.formatFieldSchema(field));
        }
        buf.append("}");
        return buf.toString();
    }

    public static void allocateVectors(Iterable<ValueVector> valueVectors, int count) {
        for (ValueVector v : valueVectors) {
            AllocationHelper.allocateNew(v, count);
        }
    }

    public static void setValueCount(Iterable<ValueVector> valueVectors, int count) {
        for (ValueVector v : valueVectors) {
            v.getMutator().setValueCount(count);
        }
    }

    private static int getColumnWidth(int[] columnWidths, int columnIndex) {
        return columnWidths == null ? 15 : (columnWidths.length > columnIndex ? columnWidths[columnIndex] : columnWidths[0]);
    }
}

