/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import oadd.org.apache.drill.exec.expr.holders.SmallIntHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.RepeatedSmallIntVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedSmallIntWriterImpl
extends AbstractFieldWriter {
    private final RepeatedSmallIntVector.Mutator mutator;
    final RepeatedSmallIntVector vector;

    public RepeatedSmallIntWriterImpl(RepeatedSmallIntVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(SmallIntHolder h2) {
        this.mutator.addSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableSmallIntHolder h2) {
        this.mutator.addSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeSmallInt(short value) {
        this.mutator.addSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void setPosition(int idx) {
        super.setPosition(idx);
        if (idx >= this.vector.getAccessor().getValueCount()) {
            this.mutator.startNewValue(idx);
        }
    }
}

