/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TwoDArrayWritable
implements Writable {
    private Class valueClass;
    private Writable[][] values;

    public TwoDArrayWritable(Class valueClass) {
        this.valueClass = valueClass;
    }

    public TwoDArrayWritable(Class valueClass, Writable[][] values) {
        this(valueClass);
        this.values = values;
    }

    public Object toArray() {
        int[] dimensions = new int[]{this.values.length, 0};
        Object result = Array.newInstance(this.valueClass, dimensions);
        for (int i = 0; i < this.values.length; ++i) {
            Object resultRow = Array.newInstance(this.valueClass, this.values[i].length);
            Array.set(result, i, resultRow);
            for (int j = 0; j < this.values[i].length; ++j) {
                Array.set(resultRow, j, this.values[i][j]);
            }
        }
        return result;
    }

    public void set(Writable[][] values) {
        this.values = values;
    }

    public Writable[][] get() {
        return this.values;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        this.values = new Writable[in.readInt()][];
        for (i = 0; i < this.values.length; ++i) {
            this.values[i] = new Writable[in.readInt()];
        }
        for (i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                Writable value;
                try {
                    value = (Writable)this.valueClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.toString());
                }
                value.readFields(in);
                this.values[i][j] = value;
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        out.writeInt(this.values.length);
        for (i = 0; i < this.values.length; ++i) {
            out.writeInt(this.values[i].length);
        }
        for (i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                this.values[i][j].write(out);
            }
        }
    }
}

