/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.codec;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.erasurecode.ECSchema;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCodecOptions;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import oadd.org.apache.hadoop.io.erasurecode.grouper.BlockGrouper;

@InterfaceAudience.Private
public abstract class ErasureCodec {
    private ECSchema schema;
    private ErasureCodecOptions codecOptions;
    private ErasureCoderOptions coderOptions;

    public ErasureCodec(Configuration conf, ErasureCodecOptions options) {
        this.schema = options.getSchema();
        this.codecOptions = options;
        boolean allowChangeInputs = false;
        this.coderOptions = new ErasureCoderOptions(this.schema.getNumDataUnits(), this.schema.getNumParityUnits(), allowChangeInputs, false);
    }

    public String getName() {
        return this.schema.getCodecName();
    }

    public ECSchema getSchema() {
        return this.schema;
    }

    public ErasureCodecOptions getCodecOptions() {
        return this.codecOptions;
    }

    protected void setCodecOptions(ErasureCodecOptions options) {
        this.codecOptions = options;
        this.schema = options.getSchema();
    }

    public ErasureCoderOptions getCoderOptions() {
        return this.coderOptions;
    }

    protected void setCoderOptions(ErasureCoderOptions options) {
        this.coderOptions = options;
    }

    public abstract ErasureEncoder createEncoder();

    public abstract ErasureDecoder createDecoder();

    public BlockGrouper createBlockGrouper() {
        BlockGrouper blockGrouper = new BlockGrouper();
        blockGrouper.setSchema(this.getSchema());
        return blockGrouper;
    }
}

