/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.token;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.io.Text;
import oadd.org.apache.hadoop.security.Credentials;
import oadd.org.apache.hadoop.security.token.Token;
import oadd.org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "Yarn"})
@InterfaceStability.Unstable
public interface DelegationTokenIssuer {
    public String getCanonicalServiceName();

    public Token<?> getDelegationToken(String var1) throws IOException;

    default public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        return null;
    }

    default public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        if (credentials == null) {
            credentials = new Credentials();
        }
        ArrayList tokens = new ArrayList();
        DelegationTokenIssuer.collectDelegationTokens(this, renewer, credentials, tokens);
        return tokens.toArray(new Token[tokens.size()]);
    }

    @InterfaceAudience.Private
    public static void collectDelegationTokens(DelegationTokenIssuer issuer, String renewer, Credentials credentials, List<Token<?>> tokens) throws IOException {
        DelegationTokenIssuer[] ancillary;
        Text service;
        Token<TokenIdentifier> token;
        String serviceName = issuer.getCanonicalServiceName();
        if (serviceName != null && (token = credentials.getToken(service = new Text(serviceName))) == null && (token = issuer.getDelegationToken(renewer)) != null) {
            tokens.add(token);
            credentials.addToken(service, token);
        }
        if ((ancillary = issuer.getAdditionalTokenIssuers()) != null) {
            for (DelegationTokenIssuer subIssuer : ancillary) {
                DelegationTokenIssuer.collectDelegationTokens(subIssuer, renewer, credentials, tokens);
            }
        }
    }
}

