/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.pentaho.aggdes.algorithm;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import oadd.org.pentaho.aggdes.algorithm.Progress;
import oadd.org.pentaho.aggdes.algorithm.Result;
import oadd.org.pentaho.aggdes.model.Aggregate;
import oadd.org.pentaho.aggdes.model.Attribute;
import oadd.org.pentaho.aggdes.model.Component;
import oadd.org.pentaho.aggdes.model.Parameter;
import oadd.org.pentaho.aggdes.model.Schema;

public interface Algorithm
extends Component {
    public Result run(Schema var1, Map<Parameter, Object> var2, Progress var3);

    public void cancel();

    public Aggregate createAggregate(Schema var1, List<Attribute> var2);

    public List<CostBenefit> computeAggregateCosts(Schema var1, Map<Parameter, Object> var2, List<Aggregate> var3);

    public static interface CostBenefit {
        public double getRowCount();

        public double getSpace();

        public double getLoadTime();

        public double getSavedQueryRowCount();

        public void describe(PrintWriter var1);
    }

    public static enum ParameterEnum implements Parameter
    {
        timeLimitSeconds("Maximum time, in seconds, to run the algorithm. After this time, the algorithm returns the best solution it has found so far.", false, Parameter.Type.INTEGER),
        aggregateLimit("Maximum number of aggregates to create", false, Parameter.Type.INTEGER),
        costLimit("Maximum total cost of the aggregates produced.", false, Parameter.Type.DOUBLE);

        private final String description;
        private final boolean required;
        private final Parameter.Type type;

        private ParameterEnum(String description, boolean required, Parameter.Type type) {
            this.description = description;
            this.required = required;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Parameter.Type getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

