/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical;

import java.util.Map;
import java.util.Objects;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import oadd.org.apache.drill.common.PlanStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonDeserialize(builder=OAuthConfigBuilder.class)
public class OAuthConfig {
    private final String callbackURL;
    private final String authorizationURL;
    private final Map<String, String> authorizationParams;
    private final String tokenType;
    private final boolean generateCSRFToken;
    private final String scope;
    private final boolean accessTokenInHeader;

    @JsonCreator
    public OAuthConfig(@JsonProperty(value="callbackURL") String callbackURL, @JsonProperty(value="authorizationURL") String authorizationURL, @JsonProperty(value="authorizationParams") Map<String, String> authorizationParams, @JsonProperty(value="tokenType") String tokenType, @JsonProperty(value="generateCSRFToken") boolean generateCSRFToken, @JsonProperty(value="scope") String scope, @JsonProperty(value="accessTokenInHeader") boolean accessTokenInHeader) {
        this.callbackURL = callbackURL;
        this.authorizationURL = authorizationURL;
        this.authorizationParams = authorizationParams;
        this.tokenType = tokenType;
        this.generateCSRFToken = generateCSRFToken;
        this.accessTokenInHeader = accessTokenInHeader;
        this.scope = scope;
    }

    public OAuthConfig(OAuthConfigBuilder builder) {
        this.callbackURL = builder.callbackURL;
        this.authorizationURL = builder.authorizationURL;
        this.authorizationParams = builder.authorizationParams;
        this.generateCSRFToken = builder.generateCSRFToken;
        this.tokenType = builder.tokenType;
        this.accessTokenInHeader = builder.accessTokenInHeader;
        this.scope = builder.scope;
    }

    public static OAuthConfigBuilder builder() {
        return new OAuthConfigBuilder();
    }

    public String getCallbackURL() {
        return this.callbackURL;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public Map<String, String> getAuthorizationParams() {
        return this.authorizationParams;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public boolean isGenerateCSRFToken() {
        return this.generateCSRFToken;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isAccessTokenInHeader() {
        return this.accessTokenInHeader;
    }

    public String toString() {
        return new PlanStringBuilder(this).field("callbackURL", this.callbackURL).field("authorizationURL", this.authorizationURL).field("authorizationParams", this.authorizationParams).field("tokenType", this.tokenType).field("generateCSRFToken", this.generateCSRFToken).field("scope", this.scope).field("accessTokenInHeader", this.accessTokenInHeader).toString();
    }

    public int hashCode() {
        return Objects.hash(this.callbackURL, this.authorizationURL, this.authorizationParams, this.tokenType, this.generateCSRFToken, this.scope, this.accessTokenInHeader);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        OAuthConfig thatConfig = (OAuthConfig)that;
        return Objects.equals(this.callbackURL, thatConfig.callbackURL) && Objects.equals(this.authorizationURL, thatConfig.authorizationURL) && Objects.equals(this.authorizationParams, thatConfig.authorizationParams) && Objects.equals(this.tokenType, thatConfig.tokenType) && Objects.equals(this.generateCSRFToken, thatConfig.generateCSRFToken) && Objects.equals(this.scope, thatConfig.scope) && Objects.equals(this.accessTokenInHeader, thatConfig.accessTokenInHeader);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class OAuthConfigBuilder {
        private String callbackURL;
        private String authorizationURL;
        private Map<String, String> authorizationParams;
        private String tokenType;
        private boolean generateCSRFToken;
        private String scope;
        private boolean accessTokenInHeader;
        private Map<String, String> tokens;

        OAuthConfigBuilder() {
        }

        public OAuthConfig build() {
            return new OAuthConfig(this);
        }

        public OAuthConfigBuilder callbackURL(String callbackURL) {
            this.callbackURL = callbackURL;
            return this;
        }

        public OAuthConfigBuilder authorizationURL(String authorizationURL) {
            this.authorizationURL = authorizationURL;
            return this;
        }

        public OAuthConfigBuilder authorizationParams(Map<String, String> authorizationParams) {
            this.authorizationParams = authorizationParams;
            return this;
        }

        public OAuthConfigBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public OAuthConfigBuilder generateCSRFToken(boolean generateCSRFToken) {
            this.generateCSRFToken = generateCSRFToken;
            return this;
        }

        public OAuthConfigBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OAuthConfigBuilder accessTokenInHeader(boolean accessTokenInHeader) {
            this.accessTokenInHeader = accessTokenInHeader;
            return this;
        }
    }
}

