/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import oadd.com.beust.jcommander.IParameterValidator;
import oadd.com.beust.jcommander.JCommander;
import oadd.com.beust.jcommander.Parameter;
import oadd.com.beust.jcommander.ParameterException;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.cache.VectorAccessibleSerializable;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.util.VectorUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DumpCat {
    private static final DrillConfig drillConfig = DrillConfig.create();
    private static final BufferAllocator allocator = RootAllocatorFactory.newRoot(drillConfig);

    public static void main(String[] args) throws Exception {
        File file;
        DumpCat dumpCat = new DumpCat();
        Options o = new Options();
        JCommander jc = null;
        try {
            jc = new JCommander((Object)o, args);
            jc.setProgramName("./drill_dumpcat");
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            String[] valid = new String[]{"-f", "file"};
            new JCommander((Object)o, valid).usage();
            System.exit(-1);
        }
        if (o.help) {
            jc.usage();
            System.exit(0);
        }
        if (!(file = new File(o.location)).exists()) {
            System.out.println(String.format("Trace file %s not created", o.location));
            System.exit(-1);
        }
        try (FileInputStream input = new FileInputStream(file.getAbsoluteFile());){
            if (o.batch < 0) {
                dumpCat.doQuery(input);
            } else {
                dumpCat.doBatch(input, o.batch, o.include_headers);
            }
        }
    }

    protected void doQuery(FileInputStream input) throws Exception {
        int batchNum = 0;
        int emptyBatchNum = 0;
        BatchSchema prevSchema = null;
        ArrayList<Integer> schemaChangeIdx = Lists.newArrayList();
        BatchMetaInfo aggBatchMetaInfo = new BatchMetaInfo();
        while (input.available() > 0) {
            VectorAccessibleSerializable vcSerializable = new VectorAccessibleSerializable(allocator);
            vcSerializable.readFromStream(input);
            VectorContainer vectorContainer = vcSerializable.get();
            aggBatchMetaInfo.add(this.getBatchMetaInfo(vcSerializable));
            if (vectorContainer.getRecordCount() == 0) {
                ++emptyBatchNum;
            }
            if (prevSchema != null && !vectorContainer.getSchema().equals(prevSchema)) {
                schemaChangeIdx.add(batchNum);
            }
            prevSchema = vectorContainer.getSchema();
            ++batchNum;
            vectorContainer.zeroVectors();
        }
        System.out.println(String.format("Total # of batches: %d", batchNum));
        System.out.println(aggBatchMetaInfo.toString());
        System.out.println(String.format("Empty batch : %d", emptyBatchNum));
        System.out.println(String.format("Schema changes : %d", schemaChangeIdx.size()));
        System.out.println(String.format("Schema change batch index : %s", ((Object)schemaChangeIdx).toString()));
    }

    protected void doBatch(FileInputStream input, int targetBatchNum, boolean showHeader) throws Exception {
        VectorContainer vectorContainer;
        int batchNum = -1;
        VectorAccessibleSerializable vcSerializable = null;
        while (input.available() > 0 && batchNum++ < targetBatchNum) {
            vcSerializable = new VectorAccessibleSerializable(allocator);
            vcSerializable.readFromStream(input);
            if (batchNum == targetBatchNum) continue;
            vectorContainer = vcSerializable.get();
            vectorContainer.zeroVectors();
        }
        if (batchNum < targetBatchNum) {
            System.out.println(String.format("Wrong input of batch # ! Total # of batch in the file is %d. Please input a number 0..%d as batch #", batchNum + 1, batchNum));
            input.close();
            System.exit(-1);
        }
        if (vcSerializable != null) {
            this.showSingleBatch(vcSerializable, showHeader);
            vectorContainer = vcSerializable.get();
            vectorContainer.zeroVectors();
        }
    }

    private void showSingleBatch(VectorAccessibleSerializable vcSerializable, boolean showHeader) {
        VectorContainer vectorContainer = vcSerializable.get();
        if (showHeader) {
            System.out.println(this.getBatchMetaInfo(vcSerializable).toString());
            System.out.println("Schema Information");
            for (VectorWrapper<?> w : vectorContainer) {
                MaterializedField field = w.getValueVector().getField();
                System.out.println(String.format("name : %s, minor_type : %s, data_mode : %s", field.getName(), field.getType().getMinorType().toString(), field.isNullable() ? "nullable" : "non-nullable"));
            }
        }
        VectorUtil.logVectorAccessibleContent(vectorContainer);
    }

    private BatchMetaInfo getBatchMetaInfo(VectorAccessibleSerializable vcSerializable) {
        int rows;
        VectorContainer vectorContainer = vcSerializable.get();
        int totalDataSize = 0;
        int selectedRows = rows = vectorContainer.getRecordCount();
        if (vectorContainer.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE) {
            selectedRows = vcSerializable.getSv2().getCount();
        }
        for (VectorWrapper w : vectorContainer) {
            totalDataSize += w.getValueVector().getBufferSize();
        }
        return new BatchMetaInfo(rows, selectedRows, totalDataSize);
    }

    static class Options {
        @Parameter(names={"-f"}, description="file containing dump", required=true)
        public String location = null;
        @Parameter(names={"-batch"}, description="id of batch to show", required=false, validateWith=BatchNumValidator.class)
        public int batch = -1;
        @Parameter(names={"-include-headers"}, description="whether include header of batch", required=false)
        public boolean include_headers = false;
        @Parameter(names={"-h", "-help", "--help"}, description="show usage", help=true)
        public boolean help = false;

        Options() {
        }
    }

    private class BatchMetaInfo {
        private long rows = 0L;
        private long selectedRows = 0L;
        private long dataSize = 0L;

        public BatchMetaInfo() {
        }

        public BatchMetaInfo(long rows, long selectedRows, long dataSize) {
            this.rows = rows;
            this.selectedRows = selectedRows;
            this.dataSize = dataSize;
        }

        public void add(BatchMetaInfo info2) {
            this.rows += info2.rows;
            this.selectedRows += info2.selectedRows;
            this.dataSize += info2.dataSize;
        }

        public String toString() {
            String avgRecSizeStr = this.rows > 0L ? String.format("Average Record Size : %d ", this.dataSize / this.rows) : "Average Record Size : 0";
            return String.format("Records : %d / %d \n", this.selectedRows, this.rows) + avgRecSizeStr + String.format("\n Total Data Size : %d", this.dataSize);
        }
    }

    public static class BatchNumValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            try {
                int batch = Integer.parseInt(value);
                if (batch < 0) {
                    throw new ParameterException("Parameter " + name + " should be non-negative number.");
                }
            }
            catch (NumberFormatException e) {
                throw new ParameterException("Parameter " + name + " should be non-negative number.");
            }
        }
    }
}

