/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.net.URL;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.parquet.Strings;

public final class PathUtils {
    public static String join(String ... parts) {
        String path = Arrays.stream(parts).peek(part -> Preconditions.checkNotNull(part, "parts cannot contain null")).filter(part -> !Strings.isNullOrEmpty((String)part)).collect(Collectors.joining("/"));
        return PathUtils.normalize(path);
    }

    public static String normalize(String path) {
        if (Strings.isNullOrEmpty((String)Preconditions.checkNotNull(path))) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        char last = path.charAt(0);
        builder.append(last);
        for (int i = 1; i < path.length(); ++i) {
            char cur = path.charAt(i);
            if (last == '/' && cur == last) continue;
            builder.append(cur);
            last = cur;
        }
        return builder.toString();
    }

    public static String getPathWithProtocol(URL url) {
        if (url.getProtocol() != null) {
            return url.getProtocol() + ":" + url.getPath();
        }
        return url.getPath();
    }
}

