/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.memory;

import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.buffer.PooledByteBufAllocatorL;
import oadd.io.netty.buffer.UnsafeDirectLittleEndian;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.HistoricalLog;
import oadd.org.apache.drill.common.concurrent.AutoCloseableLock;
import oadd.org.apache.drill.exec.memory.BaseAllocator;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocator;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.ops.BufferManager;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class AllocationManager {
    private static final AtomicLong MANAGER_ID_GENERATOR = new AtomicLong(0L);
    private static final AtomicLong LEDGER_ID_GENERATOR = new AtomicLong(0L);
    static final PooledByteBufAllocatorL INNER_ALLOCATOR = new PooledByteBufAllocatorL(DrillMetrics.getRegistry());
    private final RootAllocator root;
    private final long allocatorManagerId = MANAGER_ID_GENERATOR.incrementAndGet();
    private final int size;
    private final UnsafeDirectLittleEndian underlying;
    private final IdentityHashMap<BufferAllocator, BufferLedger> map = new IdentityHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AutoCloseableLock readLock = new AutoCloseableLock(this.lock.readLock());
    private final AutoCloseableLock writeLock = new AutoCloseableLock(this.lock.writeLock());
    private final long amCreationTime = System.nanoTime();
    private volatile BufferLedger owningLedger;
    private volatile long amDestructionTime = 0L;

    AllocationManager(BaseAllocator accountingAllocator, int size) {
        Preconditions.checkNotNull(accountingAllocator);
        accountingAllocator.assertOpen();
        this.root = accountingAllocator.root;
        this.underlying = INNER_ALLOCATOR.allocate(size);
        this.owningLedger = this.associate(accountingAllocator, false);
        this.size = this.underlying.capacity();
    }

    BufferLedger associate(BaseAllocator allocator) {
        return this.associate(allocator, true);
    }

    private BufferLedger associate(BaseAllocator allocator, boolean retain) {
        allocator.assertOpen();
        if (this.root != allocator.root) {
            throw new IllegalStateException("A buffer can only be associated between two allocators that share the same root.");
        }
        try (AutoCloseables.Closeable read = this.readLock.open();){
            BufferLedger ledger = this.map.get(allocator);
            if (ledger != null) {
                if (retain) {
                    ledger.inc();
                }
                BufferLedger bufferLedger = ledger;
                return bufferLedger;
            }
        }
        try (AutoCloseables.Closeable write = this.writeLock.open();){
            BufferLedger oldLedger;
            BufferLedger existingLedger = this.map.get(allocator);
            if (existingLedger != null) {
                if (retain) {
                    existingLedger.inc();
                }
                BufferLedger bufferLedger = existingLedger;
                return bufferLedger;
            }
            BufferLedger ledger = new BufferLedger(allocator, new ReleaseListener(allocator));
            if (retain) {
                ledger.inc();
            }
            Preconditions.checkArgument((oldLedger = this.map.put(allocator, ledger)) == null);
            allocator.associateLedger(ledger);
            BufferLedger bufferLedger = ledger;
            return bufferLedger;
        }
    }

    public static int chunkSize() {
        return INNER_ALLOCATOR.getChunkSize();
    }

    static /* synthetic */ AtomicLong access$800() {
        return LEDGER_ID_GENERATOR;
    }

    public class BufferLedger {
        private final IdentityHashMap<DrillBuf, Object> buffers = BaseAllocator.DEBUG ? new IdentityHashMap() : null;
        private final long ledgerId = AllocationManager.access$800().incrementAndGet();
        private final AtomicInteger bufRefCnt = new AtomicInteger(0);
        private final long lCreationTime = System.nanoTime();
        private volatile long lDestructionTime = 0L;
        private final BaseAllocator allocator;
        private final ReleaseListener listener;
        private final HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "BufferLedger[%d]", 1) : null;

        private BufferLedger(BaseAllocator allocator, ReleaseListener listener) {
            this.allocator = allocator;
            this.listener = listener;
        }

        public boolean transferBalance(BufferLedger target) {
            Preconditions.checkNotNull(target);
            Preconditions.checkArgument(this.allocator.root == target.allocator.root, "You can only transfer between two allocators that share the same root.");
            this.allocator.assertOpen();
            target.allocator.assertOpen();
            if (target == this) {
                return true;
            }
            try (AutoCloseables.Closeable write = AllocationManager.this.writeLock.open();){
                if (AllocationManager.this.owningLedger != this) {
                    boolean bl = true;
                    return bl;
                }
                if (BaseAllocator.DEBUG) {
                    this.historicalLog.recordEvent("transferBalance(%s)", target.allocator.name);
                    target.historicalLog.recordEvent("incoming(from %s)", ((AllocationManager)AllocationManager.this).owningLedger.allocator.name);
                }
                boolean overlimit = target.allocator.forceAllocate(AllocationManager.this.size);
                this.allocator.releaseBytes(AllocationManager.this.size);
                AllocationManager.this.owningLedger = target;
                boolean bl = overlimit;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(StringBuilder sb, int indent, BaseAllocator.Verbosity verbosity) {
            BaseAllocator.indent(sb, indent).append("ledger[").append(this.ledgerId).append("] allocator: ").append(this.allocator.name).append("), isOwning: ").append(AllocationManager.this.owningLedger == this).append(", size: ").append(AllocationManager.this.size).append(", references: ").append(this.bufRefCnt.get()).append(", life: ").append(this.lCreationTime).append("..").append(this.lDestructionTime).append(", allocatorManager: [").append(AllocationManager.this.allocatorManagerId).append(", life: ").append(AllocationManager.this.amCreationTime).append("..").append(AllocationManager.this.amDestructionTime);
            if (!BaseAllocator.DEBUG) {
                sb.append("]\n");
            } else {
                IdentityHashMap<DrillBuf, Object> identityHashMap = this.buffers;
                synchronized (identityHashMap) {
                    sb.append("] holds ").append(this.buffers.size()).append(" buffers. \n");
                    for (DrillBuf buf : this.buffers.keySet()) {
                        buf.print(sb, indent + 2, verbosity);
                        sb.append('\n');
                    }
                }
            }
        }

        private void inc() {
            this.bufRefCnt.incrementAndGet();
        }

        public int decrement(int decrement) {
            int outcome;
            this.allocator.assertOpen();
            try (AutoCloseables.Closeable write = AllocationManager.this.writeLock.open();){
                outcome = this.bufRefCnt.addAndGet(-decrement);
                if (outcome == 0) {
                    this.lDestructionTime = System.nanoTime();
                    this.listener.release();
                }
            }
            return outcome;
        }

        public BufferLedger getLedgerForAllocator(BufferAllocator allocator) {
            return AllocationManager.this.associate((BaseAllocator)allocator);
        }

        public DrillBuf newDrillBuf(int offset, int length) {
            this.allocator.assertOpen();
            return this.newDrillBuf(offset, length, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DrillBuf newDrillBuf(int offset, int length, BufferManager manager) {
            this.allocator.assertOpen();
            DrillBuf buf = new DrillBuf(this.bufRefCnt, this, AllocationManager.this.underlying, manager, this.allocator.getAsByteBufAllocator(), offset, length, false);
            if (BaseAllocator.DEBUG) {
                this.historicalLog.recordEvent("DrillBuf(BufferLedger, BufferAllocator[%s], UnsafeDirectLittleEndian[identityHashCode == %d](%s)) => ledger hc == %d", this.allocator.name, System.identityHashCode(buf), buf.toString(), System.identityHashCode(this));
                IdentityHashMap<DrillBuf, Object> identityHashMap = this.buffers;
                synchronized (identityHashMap) {
                    this.buffers.put(buf, null);
                }
            }
            return buf;
        }

        public int getSize() {
            return AllocationManager.this.size;
        }

        public int getAccountedSize() {
            try (AutoCloseables.Closeable read = AllocationManager.this.readLock.open();){
                if (AllocationManager.this.owningLedger == this) {
                    int n = AllocationManager.this.size;
                    return n;
                }
                int n = 0;
                return n;
            }
        }

        @VisibleForTesting
        protected UnsafeDirectLittleEndian getUnderlying() {
            return AllocationManager.this.underlying;
        }

        @VisibleForTesting
        protected boolean isOwningLedger() {
            return this == AllocationManager.this.owningLedger;
        }
    }

    private class ReleaseListener {
        private final BufferAllocator allocator;

        public ReleaseListener(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        public void release() {
            this.allocator.assertOpen();
            BufferLedger oldLedger = (BufferLedger)AllocationManager.this.map.remove(this.allocator);
            oldLedger.allocator.dissociateLedger(oldLedger);
            if (oldLedger == AllocationManager.this.owningLedger) {
                if (AllocationManager.this.map.isEmpty()) {
                    oldLedger.allocator.releaseBytes(AllocationManager.this.size);
                    AllocationManager.this.underlying.release();
                    AllocationManager.this.amDestructionTime = System.nanoTime();
                    AllocationManager.this.owningLedger = null;
                } else {
                    BufferLedger newLedger = (BufferLedger)AllocationManager.this.map.values().iterator().next();
                    oldLedger.transferBalance(newLedger);
                }
            } else if (AllocationManager.this.map.isEmpty()) {
                throw new IllegalStateException("The final removal of a ledger should be connected to the owning ledger.");
            }
        }
    }
}

