/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.analyze;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.drill.exec.store.ColumnExplorer;
import oadd.org.apache.hadoop.fs.Path;

public class MetadataIdentifierUtils {
    private static final String METADATA_IDENTIFIER_SEPARATOR = "/";

    public static String getMetadataIdentifierKey(List<String> values) {
        return String.join((CharSequence)METADATA_IDENTIFIER_SEPARATOR, values);
    }

    public static boolean isMetadataKeyParent(String parent, String child) {
        return child.startsWith(parent + METADATA_IDENTIFIER_SEPARATOR) || parent.equals("DEFAULT_SEGMENT");
    }

    public static String getFileMetadataIdentifier(List<String> partitionValues, Path path) {
        ArrayList<String> identifierValues = new ArrayList<String>(partitionValues);
        identifierValues.add(ColumnExplorer.ImplicitFileColumns.FILENAME.getValue(path));
        return MetadataIdentifierUtils.getMetadataIdentifierKey(identifierValues);
    }

    public static String getRowGroupMetadataIdentifier(List<String> partitionValues, Path path, int index) {
        ArrayList<String> identifierValues = new ArrayList<String>(partitionValues);
        identifierValues.add(ColumnExplorer.ImplicitFileColumns.FILENAME.getValue(path));
        identifierValues.add(Integer.toString(index));
        return MetadataIdentifierUtils.getMetadataIdentifierKey(identifierValues);
    }

    public static String[] getValuesFromMetadataIdentifier(String metadataIdentifier) {
        return metadataIdentifier.split(METADATA_IDENTIFIER_SEPARATOR);
    }
}

