/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.concurrent.Callable;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.ops.BaseOperatorContext;
import oadd.org.apache.drill.exec.ops.FragmentContextImpl;
import oadd.org.apache.drill.exec.ops.OpProfileDef;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.ops.OperatorUtilities;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.ListenableFuture;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperatorContextImpl
extends BaseOperatorContext
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(OperatorContextImpl.class);
    private boolean closed = false;
    private final OperatorStats stats;
    private ListeningExecutorService delegatePool;

    public OperatorContextImpl(PhysicalOperator popConfig, FragmentContextImpl context) throws OutOfMemoryException {
        this(popConfig, context, null);
    }

    public OperatorContextImpl(PhysicalOperator popConfig, FragmentContextImpl context, OperatorStats stats) throws OutOfMemoryException {
        super(context, context.getNewChildAllocator(popConfig.getClass().getSimpleName(), popConfig.getOperatorId(), popConfig.getInitialAllocation(), popConfig.getMaxAllocation()), popConfig);
        if (stats != null) {
            this.stats = stats;
        } else {
            OpProfileDef def = new OpProfileDef(popConfig.getOperatorId(), popConfig.getOperatorType(), OperatorUtilities.getChildCount(popConfig));
            this.stats = context.getStats().newOperatorStats(def, this.allocator);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            logger.debug("Attempted to close Operator context for {}, but context is already closed", (Object)(this.popConfig != null ? this.getName() : null));
            return;
        }
        logger.debug("Closing context for {}", (Object)(this.popConfig != null ? this.getName() : null));
        this.closed = true;
        super.close();
    }

    @Override
    public OperatorStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RESULT> ListenableFuture<RESULT> runCallableAs(final UserGroupInformation proxyUgi, final Callable<RESULT> callable) {
        OperatorContextImpl operatorContextImpl = this;
        synchronized (operatorContextImpl) {
            if (this.delegatePool == null) {
                this.delegatePool = MoreExecutors.listeningDecorator(this.getExecutor());
            }
        }
        return this.delegatePool.submit(new Callable<RESULT>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RESULT call() throws Exception {
                Object result;
                Thread currentThread = Thread.currentThread();
                String originalThreadName = currentThread.getName();
                currentThread.setName(proxyUgi.getUserName() + ":task-delegate-thread");
                try {
                    result = proxyUgi.doAs(() -> callable.call());
                }
                finally {
                    currentThread.setName(originalThreadName);
                }
                return result;
            }
        });
    }
}

