/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata.schema;

import java.io.IOException;
import oadd.org.apache.drill.exec.planner.sql.handlers.SchemaHandler;
import oadd.org.apache.drill.exec.planner.sql.parser.SqlSchema;
import oadd.org.apache.drill.exec.record.metadata.schema.FsMetastoreSchemaProvider;
import oadd.org.apache.drill.exec.record.metadata.schema.InlineSchemaProvider;
import oadd.org.apache.drill.exec.record.metadata.schema.PathSchemaProvider;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import oadd.org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import oadd.org.apache.hadoop.fs.Path;

public class SchemaProviderFactory {
    public static SchemaProvider create(SqlSchema sqlSchema, SchemaHandler schemaHandler) throws IOException {
        if (sqlSchema.hasTable()) {
            String tableName = sqlSchema.getTableName();
            WorkspaceSchemaFactory.WorkspaceSchema wsSchema = schemaHandler.getWorkspaceSchema(sqlSchema.getSchemaPath(), tableName);
            return new FsMetastoreSchemaProvider(wsSchema, tableName);
        }
        return new PathSchemaProvider(new Path(sqlSchema.getPath()));
    }

    public static SchemaProvider create(String parameterValue) throws IOException {
        String[] split = parameterValue.split("=", 2);
        if (split.length < 2) {
            throw new IOException("Incorrect parameter value format: " + parameterValue);
        }
        ProviderType providerType = ProviderType.valueOf(split[0].trim().toUpperCase());
        String value = split[1].trim();
        switch (providerType) {
            case INLINE: {
                return new InlineSchemaProvider(value);
            }
            case PATH: {
                char c = value.charAt(0);
                if (c == '\'' || c == '\"' || c == '`') {
                    value = value.substring(1, value.length() - 1);
                }
                return new PathSchemaProvider(new Path(value));
            }
        }
        throw new IOException("Unexpected provider type: " + (Object)((Object)providerType));
    }

    private static enum ProviderType {
        INLINE,
        PATH;

    }
}

