/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import oadd.org.apache.drill.common.types.TypeProtos;
import org.apache.drill.shaded.guava.com.google.common.graph.ImmutableValueGraph;
import org.apache.drill.shaded.guava.com.google.common.graph.ValueGraphBuilder;

public class ResolverTypePrecedence {
    public static final ImmutableValueGraph<TypeProtos.MinorType, Float> CAST_GRAPH = ValueGraphBuilder.directed().immutable().putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(1.0f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.BIT, (Object)Float.valueOf(1.1f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.INT, (Object)Float.valueOf(1.2f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.FLOAT4, (Object)Float.valueOf(1.3f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.DECIMAL9, (Object)Float.valueOf(1.4f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.DATE, (Object)Float.valueOf(1.5f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.INTERVALDAY, (Object)Float.valueOf(1.6f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.MONEY, (Object)Float.valueOf(1.7f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.LIST, (Object)Float.valueOf(1.8f)).putEdgeValue((Object)TypeProtos.MinorType.NULL, (Object)TypeProtos.MinorType.DICT, (Object)Float.valueOf(1.9f)).putEdgeValue((Object)TypeProtos.MinorType.BIT, (Object)TypeProtos.MinorType.TINYINT, (Object)Float.valueOf(100.0f)).putEdgeValue((Object)TypeProtos.MinorType.BIT, (Object)TypeProtos.MinorType.UINT1, (Object)Float.valueOf(100.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT1, (Object)TypeProtos.MinorType.UINT2, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT2, (Object)TypeProtos.MinorType.UINT4, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT4, (Object)TypeProtos.MinorType.UINT8, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT8, (Object)TypeProtos.MinorType.VARDECIMAL, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT4, (Object)TypeProtos.MinorType.BIGINT, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT4, (Object)TypeProtos.MinorType.FLOAT4, (Object)Float.valueOf(11.0f)).putEdgeValue((Object)TypeProtos.MinorType.UINT8, (Object)TypeProtos.MinorType.FLOAT4, (Object)Float.valueOf(12.0f)).putEdgeValue((Object)TypeProtos.MinorType.TINYINT, (Object)TypeProtos.MinorType.SMALLINT, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.SMALLINT, (Object)TypeProtos.MinorType.INT, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.INT, (Object)TypeProtos.MinorType.BIGINT, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.BIGINT, (Object)TypeProtos.MinorType.FLOAT4, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.BIGINT, (Object)TypeProtos.MinorType.VARDECIMAL, (Object)Float.valueOf(100.0f)).putEdgeValue((Object)TypeProtos.MinorType.FLOAT4, (Object)TypeProtos.MinorType.FLOAT8, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.FLOAT8, (Object)TypeProtos.MinorType.VARDECIMAL, (Object)Float.valueOf(10000.0f)).putEdgeValue((Object)TypeProtos.MinorType.DECIMAL9, (Object)TypeProtos.MinorType.DECIMAL18, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.DECIMAL18, (Object)TypeProtos.MinorType.DECIMAL28DENSE, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.DECIMAL28DENSE, (Object)TypeProtos.MinorType.DECIMAL28SPARSE, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.DECIMAL28SPARSE, (Object)TypeProtos.MinorType.DECIMAL38DENSE, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.DECIMAL38DENSE, (Object)TypeProtos.MinorType.DECIMAL38SPARSE, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.DECIMAL38SPARSE, (Object)TypeProtos.MinorType.VARDECIMAL, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.MONEY, (Object)TypeProtos.MinorType.VARDECIMAL, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARDECIMAL, (Object)TypeProtos.MinorType.FLOAT8, (Object)Float.valueOf(1000.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARDECIMAL, (Object)TypeProtos.MinorType.FLOAT4, (Object)Float.valueOf(1001.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARDECIMAL, (Object)TypeProtos.MinorType.INT, (Object)Float.valueOf(1002.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARDECIMAL, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(1003.0f)).putEdgeValue((Object)TypeProtos.MinorType.INTERVALDAY, (Object)TypeProtos.MinorType.INTERVALYEAR, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.INTERVALYEAR, (Object)TypeProtos.MinorType.INTERVAL, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.INTERVAL, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(100.0f)).putEdgeValue((Object)TypeProtos.MinorType.DICT, (Object)TypeProtos.MinorType.MAP, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.DATE, (Object)TypeProtos.MinorType.TIMESTAMP, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.TIMESTAMP, (Object)TypeProtos.MinorType.TIMESTAMPTZ, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.TIME, (Object)TypeProtos.MinorType.TIMETZ, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.TIMESTAMP, (Object)TypeProtos.MinorType.DATE, (Object)Float.valueOf(100.0f)).putEdgeValue((Object)TypeProtos.MinorType.TIMESTAMP, (Object)TypeProtos.MinorType.TIME, (Object)Float.valueOf(101.0f)).putEdgeValue((Object)TypeProtos.MinorType.TIMESTAMPTZ, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(1000.0f)).putEdgeValue((Object)TypeProtos.MinorType.TIMETZ, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(1000.0f)).putEdgeValue((Object)TypeProtos.MinorType.FIXEDCHAR, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.FIXEDBINARY, (Object)TypeProtos.MinorType.VARBINARY, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.INT, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.FLOAT8, (Object)Float.valueOf(20.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.FLOAT4, (Object)Float.valueOf(21.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.VARDECIMAL, (Object)Float.valueOf(30.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.TIMESTAMP, (Object)Float.valueOf(40.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.INTERVALDAY, (Object)Float.valueOf(50.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.BIT, (Object)Float.valueOf(60.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARCHAR, (Object)TypeProtos.MinorType.VARBINARY, (Object)Float.valueOf(70.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARBINARY, (Object)TypeProtos.MinorType.VARCHAR, (Object)Float.valueOf(80.0f)).putEdgeValue((Object)TypeProtos.MinorType.LIST, (Object)TypeProtos.MinorType.UNION, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.MAP, (Object)TypeProtos.MinorType.UNION, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.VARBINARY, (Object)TypeProtos.MinorType.UNION, (Object)Float.valueOf(10.0f)).putEdgeValue((Object)TypeProtos.MinorType.UNION, (Object)TypeProtos.MinorType.LATE, (Object)Float.valueOf(10.0f)).build();

    public static float computeCost(TypeProtos.MinorType fromType, TypeProtos.MinorType toType) {
        TreeSet<VertexDatum> remaining = new TreeSet<VertexDatum>();
        HashMap<TypeProtos.MinorType, VertexDatum> vertexData = new HashMap<TypeProtos.MinorType, VertexDatum>();
        HashSet<TypeProtos.MinorType> shortestPath = new HashSet<TypeProtos.MinorType>();
        VertexDatum sourceDatum = new VertexDatum(fromType, 0.0f, null);
        remaining.add(sourceDatum);
        vertexData.put(fromType, sourceDatum);
        while (!remaining.isEmpty()) {
            VertexDatum vertexDatum = (VertexDatum)remaining.pollFirst();
            TypeProtos.MinorType vertex = vertexDatum.vertex;
            shortestPath.add(vertex);
            if (vertex.equals(toType)) {
                return vertexDatum.totalDistance;
            }
            Set successors = CAST_GRAPH.successors((Object)vertex);
            for (TypeProtos.MinorType successor : successors) {
                if (shortestPath.contains(successor)) continue;
                float distance = ((Float)CAST_GRAPH.edgeValue((Object)vertex, (Object)successor).orElseThrow(IllegalStateException::new)).floatValue();
                float totalDistance = vertexDatum.totalDistance + distance;
                VertexDatum successorDatum = (VertexDatum)vertexData.get(successor);
                if (successorDatum == null) {
                    successorDatum = new VertexDatum(successor, totalDistance, vertexDatum);
                    vertexData.put(successor, successorDatum);
                    remaining.add(successorDatum);
                    continue;
                }
                if (!(totalDistance < successorDatum.totalDistance)) continue;
                successorDatum.totalDistance = totalDistance;
                successorDatum.predecessor = vertexDatum;
            }
        }
        return Float.POSITIVE_INFINITY;
    }

    static class VertexDatum
    implements Comparable<VertexDatum> {
        final TypeProtos.MinorType vertex;
        float totalDistance;
        VertexDatum predecessor;

        public VertexDatum(TypeProtos.MinorType vertex, float totalDistance, VertexDatum predecessor) {
            this.vertex = vertex;
            this.totalDistance = totalDistance;
            this.predecessor = predecessor;
        }

        @Override
        public int compareTo(VertexDatum other) {
            int distComparison = Float.compare(this.totalDistance, other.totalDistance);
            return distComparison != 0 ? distComparison : this.vertex.compareTo(other.vertex);
        }

        public String toString() {
            return String.format("vertex: %s, totalDistance: %f, predecessor: %s", this.vertex, Float.valueOf(this.totalDistance), this.predecessor);
        }
    }
}

