/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import oadd.org.apache.drill.common.expression.MajorTypeInLogicalExpression;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.annotations.FunctionTemplate;
import oadd.org.apache.drill.exec.expr.fn.DrillFuncHolder;
import oadd.org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import oadd.org.apache.drill.exec.resolver.ResolverTypePrecedence;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class TypeCastRules {
    private static Map<TypeProtos.MinorType, Set<TypeProtos.MinorType>> rules;
    private static final float DATAMODE_CHANGE_COST = 1.0f;
    private static final float FIELD_READER_COST = 100.0f;
    private static final float VARARG_COST = 100.0f;

    private static void initTypeRules() {
        rules = new HashMap<TypeProtos.MinorType, Set<TypeProtos.MinorType>>();
        HashSet<TypeProtos.MinorType> rule = new HashSet<TypeProtos.MinorType>();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.TINYINT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.SMALLINT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.BIGINT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.UINT4, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.UINT8, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.DECIMAL9, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.DECIMAL18, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.DECIMAL28DENSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.DECIMAL28SPARSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.VARDECIMAL, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.DECIMAL38DENSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rules.put(TypeProtos.MinorType.DECIMAL38SPARSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.MONEY, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DATE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.TIME, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rules.put(TypeProtos.MinorType.TIMESTAMP, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.TIMESTAMPTZ, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INTERVAL, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INTERVALYEAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INTERVALDAY, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rules.put(TypeProtos.MinorType.FLOAT4, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rules.put(TypeProtos.MinorType.FLOAT8, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.BIT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.FIXEDCHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.FIXED16CHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rules.put(TypeProtos.MinorType.FIXEDBINARY, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.VARCHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.VAR16CHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.VARDECIMAL);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rules.put(TypeProtos.MinorType.VARBINARY, rule);
        rules.put(TypeProtos.MinorType.MAP, Sets.newHashSet(TypeProtos.MinorType.MAP));
        rules.put(TypeProtos.MinorType.LIST, Sets.newHashSet(TypeProtos.MinorType.LIST));
        rules.put(TypeProtos.MinorType.UNION, Sets.newHashSet(TypeProtos.MinorType.UNION));
        rules.put(TypeProtos.MinorType.DICT, Sets.newHashSet(TypeProtos.MinorType.DICT));
    }

    public static boolean isCastableWithNullHandling(TypeProtos.MajorType argumentType, TypeProtos.MajorType paramType, FunctionTemplate.NullHandling nullHandling) {
        if ((argumentType.getMode() == TypeProtos.DataMode.REPEATED || paramType.getMode() == TypeProtos.DataMode.REPEATED) && argumentType.getMode() != paramType.getMode()) {
            return false;
        }
        if (nullHandling == FunctionTemplate.NullHandling.INTERNAL && argumentType.getMode() != paramType.getMode() && (paramType.getMode() != TypeProtos.DataMode.OPTIONAL || argumentType.getMode() != TypeProtos.DataMode.REQUIRED)) {
            return false;
        }
        return TypeCastRules.isCastable(argumentType.getMinorType(), paramType.getMinorType());
    }

    public static boolean isCastable(TypeProtos.MinorType from, TypeProtos.MinorType to) {
        return from.equals(TypeProtos.MinorType.NULL) || rules.get(to) != null && rules.get(to).contains(from);
    }

    public static TypeProtos.DataMode getLeastRestrictiveDataMode(TypeProtos.DataMode ... dataModes) {
        boolean hasOptional = false;
        for (TypeProtos.DataMode dataMode : dataModes) {
            switch (dataMode) {
                case REPEATED: {
                    return dataMode;
                }
                case OPTIONAL: {
                    hasOptional = true;
                }
            }
        }
        if (hasOptional) {
            return TypeProtos.DataMode.OPTIONAL;
        }
        return TypeProtos.DataMode.REQUIRED;
    }

    public static TypeProtos.MinorType getLeastRestrictiveType(TypeProtos.MinorType ... types) {
        TypeProtos.MinorType result = types[0];
        if (result == TypeProtos.MinorType.UNION) {
            return result;
        }
        for (int i = 1; i < types.length; ++i) {
            TypeProtos.MinorType next = types[i];
            if (next == TypeProtos.MinorType.UNION) {
                return next;
            }
            if (next == result) continue;
            float resultCastCost = ResolverTypePrecedence.computeCost(next, result);
            float nextCastCost = ResolverTypePrecedence.computeCost(result, next);
            if (TypeCastRules.isCastable(next, result) && resultCastCost <= nextCastCost && resultCastCost < Float.POSITIVE_INFINITY) continue;
            if (TypeCastRules.isCastable(result, next) && nextCastCost <= resultCastCost && nextCastCost < Float.POSITIVE_INFINITY) {
                result = next;
                continue;
            }
            return null;
        }
        return result;
    }

    public static Optional<TypeProtos.MinorType> getCheapestCast(TypeProtos.MinorType fromType, TypeProtos.MinorType ... toTypes) {
        TypeProtos.MinorType cheapest = null;
        float cheapestCost = Float.POSITIVE_INFINITY;
        for (TypeProtos.MinorType toType : toTypes) {
            float toTypeCost = ResolverTypePrecedence.computeCost(fromType, toType);
            if (!(toTypeCost < cheapestCost)) continue;
            cheapest = toType;
            cheapestCost = toTypeCost;
        }
        return Optional.ofNullable(cheapest);
    }

    public static float getCost(List<TypeProtos.MajorType> argumentTypes, DrillFuncHolder holder) {
        float totalCost = 0.0f;
        if (argumentTypes.size() != holder.getParamCount() && !holder.isVarArg()) {
            return Float.POSITIVE_INFINITY;
        }
        if (holder.checkPrecisionRange()) {
            ArrayList<MajorTypeInLogicalExpression> logicalExpressions = Lists.newArrayList();
            for (TypeProtos.MajorType majorType : argumentTypes) {
                logicalExpressions.add(new MajorTypeInLogicalExpression(majorType));
            }
            if (DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision() < holder.getReturnType(logicalExpressions).getPrecision()) {
                return Float.POSITIVE_INFINITY;
            }
        }
        int numOfArgs = argumentTypes.size();
        for (int i = 0; i < numOfArgs; ++i) {
            TypeProtos.MajorType argType = argumentTypes.get(i);
            TypeProtos.MajorType paramType = holder.getParamMajorType(i);
            if (holder.isFieldReader(i)) {
                totalCost += 100.0f;
                continue;
            }
            if (!TypeCastRules.isCastableWithNullHandling(argType, paramType, holder.getNullHandling())) {
                return Float.POSITIVE_INFINITY;
            }
            float castCost = ResolverTypePrecedence.computeCost(argType.getMinorType(), paramType.getMinorType());
            if (castCost == Float.POSITIVE_INFINITY) {
                return Float.POSITIVE_INFINITY;
            }
            totalCost += castCost;
            totalCost += holder.getNullHandling() == FunctionTemplate.NullHandling.INTERNAL && paramType.getMode() != argType.getMode() ? 1.0f : 0.0f;
        }
        if (holder.isVarArg()) {
            int varArgIndex;
            for (int i = varArgIndex = holder.getParamCount() - 1; i < numOfArgs && !holder.isFieldReader(varArgIndex); ++i) {
                if (holder.getParamMajorType(varArgIndex).getMode() != TypeProtos.DataMode.REQUIRED || holder.getParamMajorType(varArgIndex).getMode() == argumentTypes.get(i).getMode()) continue;
                return Float.POSITIVE_INFINITY;
            }
            totalCost += 100.0f;
            totalCost += ResolverTypePrecedence.computeCost(TypeProtos.MinorType.NULL, holder.getParamMajorType(varArgIndex).getMinorType());
            totalCost += holder.getParamMajorType(varArgIndex).getMode() == TypeProtos.DataMode.REQUIRED ? 0.0f : 1.0f;
        }
        return totalCost;
    }

    public static boolean isNumericType(TypeProtos.MinorType inputType) {
        switch (inputType) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DECIMAL9: 
            case DECIMAL18: 
            case DECIMAL28SPARSE: 
            case DECIMAL38SPARSE: 
            case VARDECIMAL: 
            case FLOAT4: 
            case FLOAT8: {
                return true;
            }
        }
        return false;
    }

    static {
        TypeCastRules.initTypeRules();
    }
}

