/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumMap;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import oadd.com.google.protobuf.ByteString;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.ClientConnection;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.security.SaslProperties;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationOutcomeListener<T extends Internal.EnumLite, C extends ClientConnection, HS extends MessageLite, HR extends MessageLite>
implements RpcOutcomeListener<UserBitShared.SaslMessage> {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationOutcomeListener.class);
    private static final ImmutableMap<UserBitShared.SaslStatus, SaslChallengeProcessor> CHALLENGE_PROCESSORS;
    private final BasicClient<T, C, HS, HR> client;
    private final C connection;
    private final T saslRpcType;
    private final UserGroupInformation ugi;
    private final RpcOutcomeListener<?> completionListener;

    public AuthenticationOutcomeListener(BasicClient<T, C, HS, HR> client, C connection, T saslRpcType, UserGroupInformation ugi, RpcOutcomeListener<?> completionListener) {
        this.client = client;
        this.connection = connection;
        this.saslRpcType = saslRpcType;
        this.ugi = ugi;
        this.completionListener = completionListener;
    }

    public void initiate(String mechanismName) {
        logger.trace("Initiating SASL exchange.");
        try {
            SaslClient saslClient = this.connection.getSaslClient();
            ByteString responseData = saslClient.hasInitialResponse() ? ByteString.copyFrom(AuthenticationOutcomeListener.evaluateChallenge(this.ugi, saslClient, new byte[0])) : ByteString.EMPTY;
            this.client.send(new AuthenticationOutcomeListener<T, C, HS, HR>(this.client, this.connection, this.saslRpcType, this.ugi, this.completionListener), this.connection, this.saslRpcType, UserBitShared.SaslMessage.newBuilder().setMechanism(mechanismName).setStatus(UserBitShared.SaslStatus.SASL_START).setData(responseData).build(), UserBitShared.SaslMessage.class, true, new ByteBuf[0]);
            logger.trace("Initiated SASL exchange.");
        }
        catch (Exception e) {
            this.completionListener.failed(RpcException.mapException(e));
        }
    }

    @Override
    public void failed(RpcException ex) {
        this.completionListener.failed(RpcException.mapException(ex));
    }

    @Override
    public void success(UserBitShared.SaslMessage value, ByteBuf buffer) {
        logger.trace("Server responded with message of type: {}", (Object)value.getStatus());
        SaslChallengeProcessor processor = CHALLENGE_PROCESSORS.get(value.getStatus());
        if (processor == null) {
            this.completionListener.failed(RpcException.mapException(new SaslException("Server sent a corrupt message.")));
        } else {
            String mechanism = this.connection.getSaslClient().getMechanismName();
            try {
                SaslChallengeContext<C> context = new SaslChallengeContext<C>(value, this.ugi, this.connection);
                UserBitShared.SaslMessage saslResponse = processor.process(context);
                if (saslResponse != null) {
                    this.client.send(new AuthenticationOutcomeListener<T, C, HS, HR>(this.client, this.connection, this.saslRpcType, this.ugi, this.completionListener), this.connection, this.saslRpcType, saslResponse, UserBitShared.SaslMessage.class, true, new ByteBuf[0]);
                } else {
                    this.completionListener.success(null, null);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Successfully authenticated to server using {} mechanism and encryption context: {}", (Object)mechanism, (Object)this.connection.getEncryptionCtxtString());
                    }
                }
            }
            catch (Exception e) {
                logger.error("Authentication with encryption context: {} using mechanism {} failed with {}", this.connection.getEncryptionCtxtString(), mechanism, e.getMessage());
                this.completionListener.failed(RpcException.mapException(e));
            }
        }
    }

    @Override
    public void interrupted(InterruptedException e) {
        this.completionListener.interrupted(e);
    }

    private static byte[] evaluateChallenge(UserGroupInformation ugi, final SaslClient saslClient, final byte[] challengeBytes) throws SaslException {
        try {
            return ugi.doAs(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return saslClient.evaluateChallenge(challengeBytes);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw new SaslException(String.format("Unexpected failure (%s)", saslClient.getMechanismName()), e.getCause());
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException(String.format("Unexpected failure (%s)", saslClient.getMechanismName()), e);
        }
    }

    private static <CC extends ClientConnection> void handleSuccess(SaslChallengeContext<CC> context) throws SaslException {
        Object connection = context.connection;
        SaslClient saslClient = connection.getSaslClient();
        try {
            String expectedQOP;
            String negotiatedQOP = saslClient.getNegotiatedProperty("javax.security.sasl.qop").toString();
            String string = expectedQOP = connection.isEncryptionEnabled() ? SaslProperties.QualityOfProtection.PRIVACY.getSaslQop() : SaslProperties.QualityOfProtection.AUTHENTICATION.getSaslQop();
            if (!negotiatedQOP.equals(expectedQOP)) {
                throw new SaslException(String.format("Mismatch in negotiated QOP value: %s and Expected QOP value: %s", negotiatedQOP, expectedQOP));
            }
            if (connection.isEncryptionEnabled()) {
                int negotiatedRawSendSize = Integer.parseInt(saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize").toString());
                if (negotiatedRawSendSize <= 0) {
                    throw new SaslException(String.format("Negotiated rawSendSize: %d is invalid. Please check the configured value of encryption.sasl.max_wrapped_size. It might be configured to a very small value.", negotiatedRawSendSize));
                }
                connection.setWrapSizeLimit(negotiatedRawSendSize);
            }
        }
        catch (Exception e) {
            throw new SaslException(String.format("Unexpected failure while retrieving negotiated property values (%s)", e.getMessage()), e);
        }
        if (connection.isEncryptionEnabled()) {
            connection.addSecurityHandlers();
        } else {
            connection.disposeSaslClient();
        }
    }

    static {
        EnumMap<UserBitShared.SaslStatus, SaslChallengeProcessor> map = new EnumMap<UserBitShared.SaslStatus, SaslChallengeProcessor>(UserBitShared.SaslStatus.class);
        map.put(UserBitShared.SaslStatus.SASL_IN_PROGRESS, new SaslInProgressProcessor());
        map.put(UserBitShared.SaslStatus.SASL_SUCCESS, new SaslSuccessProcessor());
        map.put(UserBitShared.SaslStatus.SASL_FAILED, new SaslFailedProcessor());
        CHALLENGE_PROCESSORS = Maps.immutableEnumMap(map);
    }

    private static class SaslChallengeContext<C extends ClientConnection> {
        final UserBitShared.SaslMessage challenge;
        final UserGroupInformation ugi;
        final C connection;

        SaslChallengeContext(UserBitShared.SaslMessage challenge, UserGroupInformation ugi, C connection) {
            this.challenge = Preconditions.checkNotNull(challenge);
            this.ugi = Preconditions.checkNotNull(ugi);
            this.connection = (ClientConnection)Preconditions.checkNotNull(connection);
        }
    }

    private static interface SaslChallengeProcessor {
        public <CC extends ClientConnection> UserBitShared.SaslMessage process(SaslChallengeContext<CC> var1) throws Exception;
    }

    private static class SaslInProgressProcessor
    implements SaslChallengeProcessor {
        private SaslInProgressProcessor() {
        }

        @Override
        public <CC extends ClientConnection> UserBitShared.SaslMessage process(SaslChallengeContext<CC> context) throws Exception {
            UserBitShared.SaslMessage.Builder response = UserBitShared.SaslMessage.newBuilder();
            SaslClient saslClient = context.connection.getSaslClient();
            byte[] responseBytes = AuthenticationOutcomeListener.evaluateChallenge(context.ugi, saslClient, context.challenge.getData().toByteArray());
            boolean isComplete = saslClient.isComplete();
            logger.trace("Evaluated challenge. Completed? {}.", (Object)isComplete);
            response.setData(responseBytes != null ? ByteString.copyFrom(responseBytes) : ByteString.EMPTY);
            response.setStatus(isComplete ? UserBitShared.SaslStatus.SASL_SUCCESS : UserBitShared.SaslStatus.SASL_IN_PROGRESS);
            return response.build();
        }
    }

    private static class SaslSuccessProcessor
    implements SaslChallengeProcessor {
        private SaslSuccessProcessor() {
        }

        @Override
        public <CC extends ClientConnection> UserBitShared.SaslMessage process(SaslChallengeContext<CC> context) throws Exception {
            SaslClient saslClient = context.connection.getSaslClient();
            if (saslClient.isComplete()) {
                AuthenticationOutcomeListener.handleSuccess(context);
                return null;
            }
            AuthenticationOutcomeListener.evaluateChallenge(context.ugi, saslClient, context.challenge.getData().toByteArray());
            if (saslClient.isComplete()) {
                AuthenticationOutcomeListener.handleSuccess(context);
                return null;
            }
            throw new SaslException("Server allegedly succeeded authentication, but client did not. Suspicious?");
        }
    }

    private static class SaslFailedProcessor
    implements SaslChallengeProcessor {
        private SaslFailedProcessor() {
        }

        @Override
        public <CC extends ClientConnection> UserBitShared.SaslMessage process(SaslChallengeContext<CC> context) throws Exception {
            throw new SaslException(String.format("Authentication failed. Incorrect credentials? [Details: %s]", context.connection.getEncryptionCtxtString()));
        }
    }
}

