/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.impl.AccessorUtilities;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.ReaderEvents;
import oadd.org.joda.time.Period;

public abstract class AbstractScalarReader
implements ScalarReader,
ReaderEvents {
    protected ColumnReaderIndex vectorIndex;
    protected NullStateReader nullStateReader;

    public static ScalarObjectReader nullReader(ColumnMetadata schema) {
        return new ScalarObjectReader(new NullReader(schema));
    }

    @Override
    public void bindIndex(ColumnReaderIndex rowIndex) {
        this.vectorIndex = rowIndex;
        this.nullStateReader.bindIndex(rowIndex);
    }

    @Override
    public void bindNullState(NullStateReader nullStateReader) {
        this.nullStateReader = nullStateReader;
    }

    @Override
    public ObjectType type() {
        return ObjectType.SCALAR;
    }

    @Override
    public ValueType extendedType() {
        return this.valueType();
    }

    @Override
    public NullStateReader nullStateReader() {
        return this.nullStateReader;
    }

    @Override
    public void reposition() {
    }

    @Override
    public boolean isNull() {
        return this.nullStateReader.isNull();
    }

    protected UnsupportedConversionError conversionError(String javaType) {
        return UnsupportedConversionError.writeError(this.schema(), javaType);
    }

    @Override
    public boolean getBoolean() {
        throw this.conversionError("boolean");
    }

    @Override
    public int getInt() {
        throw this.conversionError("int");
    }

    @Override
    public long getLong() {
        throw this.conversionError("long");
    }

    @Override
    public float getFloat() {
        throw this.conversionError("double");
    }

    @Override
    public double getDouble() {
        throw this.conversionError("double");
    }

    @Override
    public String getString() {
        throw this.conversionError("String");
    }

    @Override
    public byte[] getBytes() {
        throw this.conversionError("bytes");
    }

    @Override
    public BigDecimal getDecimal() {
        throw this.conversionError("Decimal");
    }

    @Override
    public Period getPeriod() {
        throw this.conversionError("Period");
    }

    @Override
    public LocalDate getDate() {
        throw this.conversionError("Date");
    }

    @Override
    public LocalTime getTime() {
        throw this.conversionError("Time");
    }

    @Override
    public Instant getTimestamp() {
        throw this.conversionError("Timestamp");
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        switch (this.valueType()) {
            case BOOLEAN: {
                return this.getBoolean();
            }
            case BYTES: {
                return this.getBytes();
            }
            case DECIMAL: {
                return this.getDecimal();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case INTEGER: {
                return this.getInt();
            }
            case LONG: {
                return this.getLong();
            }
            case PERIOD: {
                return this.getPeriod();
            }
            case STRING: {
                return this.getString();
            }
            case DATE: {
                return this.getDate();
            }
            case TIME: {
                return this.getTime();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
        }
        throw new IllegalStateException("Unexpected type: " + (Object)((Object)this.valueType()));
    }

    @Override
    public Object getValue() {
        if (this.isNull()) {
            return null;
        }
        switch (this.extendedType()) {
            case DATE: {
                return this.getDate();
            }
            case TIME: {
                return this.getTime();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
        }
        return this.getObject();
    }

    @Override
    public String getAsString() {
        if (this.isNull()) {
            return "null";
        }
        switch (this.extendedType()) {
            case BYTES: {
                return AccessorUtilities.bytesToString(this.getBytes());
            }
            case FLOAT: {
                return Double.toString(this.getFloat());
            }
            case DOUBLE: {
                return Double.toString(this.getDouble());
            }
            case INTEGER: {
                return Integer.toString(this.getInt());
            }
            case LONG: {
                return Long.toString(this.getLong());
            }
            case STRING: {
                return "\"" + this.getString() + "\"";
            }
            case DECIMAL: {
                return this.getDecimal().toPlainString();
            }
            case PERIOD: {
                return this.getPeriod().normalizedStandard().toString();
            }
        }
        return this.getValue().toString();
    }

    public static class ScalarObjectReader
    extends AbstractObjectReader {
        private final AbstractScalarReader scalarReader;

        public ScalarObjectReader(AbstractScalarReader scalarReader) {
            this.scalarReader = scalarReader;
        }

        @Override
        public ScalarReader scalar() {
            return this.scalarReader;
        }

        @Override
        public Object getObject() {
            return this.scalarReader.getObject();
        }

        @Override
        public String getAsString() {
            return this.scalarReader.getAsString();
        }

        @Override
        public ReaderEvents events() {
            return this.scalarReader;
        }

        @Override
        public ColumnReader reader() {
            return this.scalarReader;
        }
    }

    public static class NullReader
    extends AbstractScalarReader {
        protected final ColumnMetadata schema;

        protected NullReader(ColumnMetadata schema) {
            this.schema = schema;
        }

        @Override
        public ValueType valueType() {
            return ValueType.NULL;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public void bindIndex(ColumnReaderIndex rowIndex) {
        }

        @Override
        public ColumnMetadata schema() {
            return this.schema;
        }

        @Override
        public void bindBuffer() {
        }
    }
}

