/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.accessor.ArrayReader;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.DictWriter;
import oadd.org.apache.drill.exec.vector.accessor.ObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.VariantWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;

public abstract class AbstractArrayWriter
implements ArrayWriter,
WriterEvents {
    private final ColumnMetadata schema;
    protected AbstractObjectWriter elementObjWriter;
    protected final OffsetVectorWriter offsetsWriter;
    protected ColumnWriterIndex outerIndex;
    protected ArrayElementWriterIndex elementIndex;

    public AbstractArrayWriter(ColumnMetadata schema, AbstractObjectWriter elementObjWriter, OffsetVectorWriter offsetVectorWriter) {
        this.schema = schema;
        this.elementObjWriter = elementObjWriter;
        this.offsetsWriter = offsetVectorWriter;
    }

    @Override
    public void bindListener(WriterEvents.ColumnWriterListener listener) {
        this.elementObjWriter.events().bindListener(listener);
        this.offsetsWriter.bindListener(listener);
    }

    @Override
    public ObjectType type() {
        return ObjectType.ARRAY;
    }

    @Override
    public ObjectType entryType() {
        return this.elementObjWriter.type();
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public ObjectWriter entry() {
        return this.elementObjWriter;
    }

    @Override
    public ScalarWriter scalar() {
        return this.elementObjWriter.scalar();
    }

    @Override
    public TupleWriter tuple() {
        return this.elementObjWriter.tuple();
    }

    @Override
    public ArrayWriter array() {
        return this.elementObjWriter.array();
    }

    @Override
    public VariantWriter variant() {
        return this.elementObjWriter.variant();
    }

    @Override
    public DictWriter dict() {
        return this.elementObjWriter.dict();
    }

    @Override
    public int size() {
        return this.elementIndex.arraySize();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    @Override
    public void setNull() {
        throw new IllegalStateException("Not nullable");
    }

    @Override
    public int rowStartIndex() {
        return this.outerIndex.rowStartIndex();
    }

    @Override
    public int lastWriteIndex() {
        return this.offsetsWriter.lastWriteIndex();
    }

    @Override
    public int writeIndex() {
        return this.outerIndex.vectorIndex();
    }

    @Override
    public void setNull(boolean isNull) {
        if (isNull) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void copy(ColumnReader from) {
        ArrayReader source = (ArrayReader)from;
        ObjectReader entryReader = source.entry();
        while (source.next()) {
            this.elementObjWriter.writer().copy(entryReader.reader());
            this.save();
        }
    }

    public OffsetVectorWriter offsetWriter() {
        return this.offsetsWriter;
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attribute("elementObjWriter");
        this.elementObjWriter.dump(format);
        format.endObject();
    }

    public class ArrayElementWriterIndex
    implements ColumnWriterIndex {
        private int elementIndex;

        public void reset() {
            this.elementIndex = 0;
        }

        @Override
        public int vectorIndex() {
            return this.elementIndex + AbstractArrayWriter.this.offsetsWriter.nextOffset();
        }

        @Override
        public int rowStartIndex() {
            return AbstractArrayWriter.this.offsetsWriter.rowStartOffset();
        }

        public int arraySize() {
            return this.elementIndex;
        }

        @Override
        public void nextElement() {
        }

        @Override
        public void prevElement() {
        }

        protected void next() {
            ++this.elementIndex;
        }

        protected void prev() {
            --this.elementIndex;
        }

        public int valueStartOffset() {
            return AbstractArrayWriter.this.offsetsWriter.nextOffset();
        }

        @Override
        public void rollover() {
        }

        @Override
        public ColumnWriterIndex outerIndex() {
            return AbstractArrayWriter.this.outerIndex;
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " elementIndex = " + this.elementIndex + "]";
        }
    }

    public static abstract class BaseArrayWriter
    extends AbstractArrayWriter {
        public BaseArrayWriter(ColumnMetadata schema, UInt4Vector offsetVector, AbstractObjectWriter elementObjWriter) {
            super(schema, elementObjWriter, new OffsetVectorWriterImpl(offsetVector));
        }

        @Override
        public void bindIndex(ColumnWriterIndex index) {
            assert (this.elementIndex != null);
            this.outerIndex = index;
            this.offsetsWriter.bindIndex(index);
            this.elementObjWriter.events().bindIndex(this.elementIndex);
        }

        @Override
        public void startWrite() {
            this.elementIndex.reset();
            this.offsetsWriter.startWrite();
            this.elementObjWriter.events().startWrite();
        }

        @Override
        public void startRow() {
            this.offsetsWriter.startRow();
            this.elementIndex.reset();
            this.elementObjWriter.events().startRow();
        }

        @Override
        public void endArrayValue() {
            this.offsetsWriter.setNextOffset(this.elementIndex.vectorIndex());
            this.elementIndex.reset();
        }

        @Override
        public void restartRow() {
            this.offsetsWriter.restartRow();
            this.elementIndex.reset();
            this.elementObjWriter.events().restartRow();
        }

        @Override
        public void saveRow() {
            this.offsetsWriter.saveRow();
            this.elementObjWriter.events().saveRow();
        }

        @Override
        public void preRollover() {
            this.elementObjWriter.events().preRollover();
            this.offsetsWriter.preRollover();
        }

        @Override
        public void postRollover() {
            this.elementObjWriter.events().postRollover();
            this.offsetsWriter.postRollover();
            this.elementIndex.rollover();
        }

        @Override
        public void endWrite() {
            this.offsetsWriter.endWrite();
            this.elementObjWriter.events().endWrite();
        }

        @Override
        public int lastWriteIndex() {
            return this.outerIndex.vectorIndex();
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.extend();
            super.dump(format);
            format.attribute("elementIndex", this.elementIndex.vectorIndex()).attribute("offsetsWriter");
            this.offsetsWriter.dump(format);
        }
    }

    public static class ArrayObjectWriter
    extends AbstractObjectWriter {
        protected final AbstractArrayWriter arrayWriter;

        public ArrayObjectWriter(AbstractArrayWriter arrayWriter) {
            this.arrayWriter = arrayWriter;
        }

        @Override
        public ArrayWriter array() {
            return this.arrayWriter;
        }

        @Override
        public ColumnWriter writer() {
            return this.arrayWriter;
        }

        @Override
        public WriterEvents events() {
            return this.arrayWriter;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("arrayWriter");
            this.arrayWriter.dump(format);
            format.endObject();
        }
    }
}

