/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnAccessorUtils;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.NullableScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.ScalarArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.dummy.DummyArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.dummy.DummyScalarWriter;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;

public class ColumnWriterFactory {
    private static final int typeCount = TypeProtos.MinorType.values().length;
    private static final Class<? extends BaseScalarWriter>[] requiredWriters = new Class[typeCount];

    public static AbstractObjectWriter buildColumnWriter(ColumnMetadata schema, ValueVector vector) {
        if (vector == null) {
            return ColumnWriterFactory.buildDummyColumnWriter(schema);
        }
        assert (schema.type() == vector.getField().getType().getMinorType());
        assert (schema.mode() == vector.getField().getType().getMode());
        switch (schema.type()) {
            case GENERIC_OBJECT: 
            case LATE: 
            case NULL: 
            case LIST: 
            case MAP: 
            case DICT: 
            case UNION: {
                throw new UnsupportedOperationException(schema.type().toString());
            }
        }
        switch (schema.mode()) {
            case OPTIONAL: {
                return ColumnWriterFactory.nullableScalarWriter(schema, (NullableVector)vector);
            }
            case REQUIRED: {
                return ColumnWriterFactory.requiredScalarWriter(schema, vector);
            }
            case REPEATED: {
                return ColumnWriterFactory.repeatedScalarWriter(schema, (RepeatedValueVector)vector);
            }
        }
        throw new UnsupportedOperationException(schema.mode().toString());
    }

    private static AbstractScalarWriterImpl.ScalarObjectWriter requiredScalarWriter(ColumnMetadata schema, ValueVector vector) {
        BaseScalarWriter baseWriter = ColumnWriterFactory.newWriter(vector);
        baseWriter.bindSchema(schema);
        return new AbstractScalarWriterImpl.ScalarObjectWriter(baseWriter);
    }

    private static AbstractScalarWriterImpl.ScalarObjectWriter nullableScalarWriter(ColumnMetadata schema, NullableVector vector) {
        BaseScalarWriter baseWriter = ColumnWriterFactory.newWriter(vector.getValuesVector());
        baseWriter.bindSchema(schema);
        return NullableScalarWriter.build(schema, vector, baseWriter);
    }

    private static AbstractObjectWriter repeatedScalarWriter(ColumnMetadata schema, RepeatedValueVector vector) {
        BaseScalarWriter baseWriter = ColumnWriterFactory.newWriter(vector.getDataVector());
        baseWriter.bindSchema(schema);
        return ScalarArrayWriter.build(schema, vector, baseWriter);
    }

    public static AbstractObjectWriter buildDummyColumnWriter(ColumnMetadata schema) {
        switch (schema.type()) {
            case GENERIC_OBJECT: 
            case LATE: 
            case LIST: 
            case MAP: 
            case DICT: 
            case UNION: {
                throw new UnsupportedOperationException(schema.type().toString());
            }
        }
        AbstractScalarWriterImpl.ScalarObjectWriter scalarWriter = new AbstractScalarWriterImpl.ScalarObjectWriter(new DummyScalarWriter(schema));
        switch (schema.mode()) {
            case OPTIONAL: 
            case REQUIRED: {
                return scalarWriter;
            }
            case REPEATED: {
                return new AbstractArrayWriter.ArrayObjectWriter(new DummyArrayWriter(schema, scalarWriter));
            }
        }
        throw new UnsupportedOperationException(schema.mode().toString());
    }

    public static BaseScalarWriter newWriter(ValueVector vector) {
        TypeProtos.MajorType major = vector.getField().getType();
        TypeProtos.MinorType type = major.getMinorType();
        try {
            Class<? extends BaseScalarWriter> accessorClass = requiredWriters[type.ordinal()];
            if (accessorClass == null) {
                throw new UnsupportedOperationException(type.toString());
            }
            Constructor<? extends BaseScalarWriter> ctor = accessorClass.getConstructor(ValueVector.class);
            return ctor.newInstance(vector);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ColumnAccessorUtils.defineRequiredWriters(requiredWriters);
    }
}

