/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.commons.lang3.ArrayUtils;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.RepeatedValueHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.SchemaChangeCallBack;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.AbstractContainerVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.EmptyValuePopulator;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;

public abstract class AbstractRepeatedMapVector
extends AbstractMapVector
implements RepeatedValueVector {
    protected final UInt4Vector offsets;
    protected final EmptyValuePopulator emptyPopulator;
    private transient AbstractRepeatedMapTransferPair<?> ephPair;

    protected AbstractRepeatedMapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this(field, new UInt4Vector(BaseRepeatedValueVector.OFFSETS_FIELD, allocator), callBack);
    }

    protected AbstractRepeatedMapVector(MaterializedField field, UInt4Vector offsets, CallBack callBack) {
        super(field, offsets.getAllocator(), callBack);
        this.offsets = offsets;
        this.emptyPopulator = new EmptyValuePopulator(offsets);
    }

    @Override
    public UInt4Vector getOffsetVector() {
        return this.offsets;
    }

    @Override
    public ValueVector getDataVector() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(VectorDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.offsets.setInitialCapacity(numRecords + 1);
        for (ValueVector v : this) {
            v.setInitialCapacity(numRecords * 5);
        }
    }

    public void allocateNew(int groupCount, int innerValueCount) {
        this.clear();
        try {
            this.allocateOffsetsNew(groupCount);
            for (ValueVector v : this.getChildren()) {
                AllocationHelper.allocatePrecomputedChildCount(v, groupCount, 50, innerValueCount);
            }
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.getMutator().reset();
    }

    public void allocateOffsetsNew(int groupCount) {
        this.offsets.allocateNew(groupCount + 1);
        this.offsets.zeroVector();
    }

    public Iterator<String> fieldNameIterator() {
        return this.getChildFieldNames().iterator();
    }

    @Override
    public List<ValueVector> getPrimitiveVectors() {
        List<ValueVector> primitiveVectors = super.getPrimitiveVectors();
        primitiveVectors.add(this.offsets);
        return primitiveVectors;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.offsets.getBufferSize() + super.getBufferSize();
    }

    @Override
    public int getAllocatedSize() {
        return this.offsets.getAllocatedSize() + super.getAllocatedSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = this.offsets.getBufferSizeFor(valueCount);
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize;
    }

    @Override
    public void close() {
        this.offsets.close();
        super.close();
    }

    public TransferPair getTransferPairToSingleMap(String reference, BufferAllocator allocator) {
        return new SingleMapTransferPair(this, reference, allocator);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = super.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        return success;
    }

    public void copyFromSafe(int fromIndex, int thisIndex, AbstractRepeatedMapVector from) {
        if (this.ephPair == null || this.ephPair.from != from) {
            this.ephPair = (AbstractRepeatedMapTransferPair)from.makeTransferPair(this);
        }
        this.ephPair.copyValueSafe(fromIndex, thisIndex);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (AbstractRepeatedMapVector)from);
    }

    @Override
    public int getValueCapacity() {
        return Math.max(this.offsets.getValueCapacity() - 1, 0);
    }

    @Override
    public void exchange(ValueVector other) {
        super.exchange(other);
        this.offsets.exchange(((AbstractRepeatedMapVector)other).offsets);
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return ArrayUtils.addAll(this.offsets.getBuffers(clear), super.getBuffers(clear));
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        List<UserBitShared.SerializedField> children = metadata.getChildList();
        UserBitShared.SerializedField offsetField = children.get(0);
        this.offsets.load(offsetField, buffer);
        int bufOffset = offsetField.getBufferLength();
        for (int i = 1; i < children.size(); ++i) {
            UserBitShared.SerializedField child = children.get(i);
            MaterializedField fieldDef = MaterializedField.create(child);
            ValueVector vector = this.getChild(fieldDef.getName());
            if (vector == null) {
                vector = BasicTypeHelper.getNewVector(fieldDef, this.allocator);
                this.putChild(fieldDef.getName(), vector);
            }
            int vectorLength = child.getBufferLength();
            vector.load(child, buffer.slice(bufOffset, vectorLength));
            bufOffset += vectorLength;
        }
        assert (bufOffset == buffer.writerIndex());
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder builder = this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.getAccessor().getValueCount());
        builder.addChild(this.offsets.getMetadata());
        for (ValueVector child : this.getChildren()) {
            builder.addChild(child.getMetadata());
        }
        return builder.build();
    }

    @Override
    public void clear() {
        this.getMutator().reset();
        this.offsets.clear();
        for (ValueVector vector : this.getChildren()) {
            vector.clear();
        }
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        super.collectLedgers(ledgers);
        this.offsets.collectLedgers(ledgers);
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int entryCount = this.offsets.getAccessor().get(valueCount);
        int count = this.offsets.getPayloadByteCount(valueCount);
        for (ValueVector v : this.getChildren()) {
            count += v.getPayloadByteCount(entryCount);
        }
        return count;
    }

    @Override
    public abstract Accessor getAccessor();

    abstract RepeatedValueHolder getValueHolder();

    public abstract class Accessor
    implements RepeatedValueVector.RepeatedAccessor {
        public void get(int index, RepeatedValueHolder holder) {
            assert (index < AbstractRepeatedMapVector.this.getValueCapacity()) : String.format("Attempted to access index %d when value capacity is %d", index, AbstractRepeatedMapVector.this.getValueCapacity());
            UInt4Vector.Accessor offsetsAccessor = AbstractRepeatedMapVector.this.offsets.getAccessor();
            holder.start = offsetsAccessor.get(index);
            holder.end = offsetsAccessor.get(index + 1);
        }

        @Override
        public int getValueCount() {
            return Math.max(AbstractRepeatedMapVector.this.offsets.getAccessor().getValueCount() - 1, 0);
        }

        @Override
        public int getInnerValueCount() {
            int valueCount = this.getValueCount();
            if (valueCount == 0) {
                return 0;
            }
            return AbstractRepeatedMapVector.this.offsets.getAccessor().get(valueCount);
        }

        @Override
        public int getInnerValueCountAt(int index) {
            return AbstractRepeatedMapVector.this.offsets.getAccessor().get(index + 1) - AbstractRepeatedMapVector.this.offsets.getAccessor().get(index);
        }

        @Override
        public boolean isEmpty(int index) {
            return false;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }
    }

    static class SingleMapTransferPair
    implements TransferPair {
        private static final TypeProtos.MajorType MAP_TYPE = Types.required(TypeProtos.MinorType.MAP);
        private final TransferPair[] pairs;
        private final AbstractRepeatedMapVector from;
        private final MapVector to;

        public SingleMapTransferPair(AbstractRepeatedMapVector from, String path, BufferAllocator allocator) {
            this(from, new MapVector(MaterializedField.create(path, MAP_TYPE), allocator, (CallBack)new SchemaChangeCallBack()), false);
        }

        public SingleMapTransferPair(AbstractRepeatedMapVector from, MapVector to, boolean allocate) {
            this.from = from;
            this.to = to;
            this.pairs = new TransferPair[from.size()];
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                ValueVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getType(), vector.getClass());
                if (allocate && to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        @Override
        public void transfer() {
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            this.to.getMutator().setValueCount(this.from.getAccessor().getValueCount());
            this.from.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            for (TransferPair p : this.pairs) {
                p.copyValueSafe(from, to);
            }
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            for (TransferPair p : this.pairs) {
                p.splitAndTransfer(startIndex, length);
            }
            this.to.getMutator().setValueCount(length);
        }
    }

    abstract class AbstractRepeatedMapTransferPair<T extends AbstractRepeatedMapVector>
    implements TransferPair {
        protected final T to;
        protected final T from;
        private final TransferPair[] pairs;
        final /* synthetic */ AbstractRepeatedMapVector this$0;

        public AbstractRepeatedMapTransferPair(T to) {
            this(this$0, (AbstractRepeatedMapVector)to, true);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public AbstractRepeatedMapTransferPair(T to, boolean allocate) {
            this.this$0 = (AbstractRepeatedMapVector)this$0;
            this.from = this$0;
            this.to = to;
            this.pairs = new TransferPair[((AbstractMapVector)this.from).size()];
            int i = 0;
            for (String child : ((AbstractContainerVector)this.from).getChildFieldNames()) {
                int preSize = ((AbstractMapVector)to).size();
                ValueVector vector = ((AbstractContainerVector)this.from).getChild(child);
                if (vector == null) continue;
                Object newVector = ((AbstractMapVector)to).addOrGet(child, vector.getField().getType(), vector.getClass());
                if (allocate && ((AbstractMapVector)to).size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        @Override
        public void transfer() {
            ((AbstractRepeatedMapVector)this.from).offsets.transferTo(((AbstractRepeatedMapVector)this.to).offsets);
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            ((AbstractRepeatedMapVector)this.from).clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int srcIndex, int destIndex) {
            RepeatedValueHolder holder = this.this$0.getValueHolder();
            ((AbstractRepeatedMapVector)this.from).getAccessor().get(srcIndex, holder);
            ((AbstractRepeatedMapVector)this.to).emptyPopulator.populate(destIndex + 1);
            int newIndex = ((AbstractRepeatedMapVector)this.to).offsets.getAccessor().get(destIndex);
            int i = holder.start;
            while (i < holder.end) {
                for (TransferPair p : this.pairs) {
                    p.copyValueSafe(i, newIndex);
                }
                ++i;
                ++newIndex;
            }
            ((AbstractRepeatedMapVector)this.to).offsets.getMutator().setSafe(destIndex + 1, newIndex);
        }

        @Override
        public void splitAndTransfer(int groupStart, int groups) {
            UInt4Vector.Accessor a = ((AbstractRepeatedMapVector)this.from).offsets.getAccessor();
            UInt4Vector.Mutator m3 = ((AbstractRepeatedMapVector)this.to).offsets.getMutator();
            int startPos = a.get(groupStart);
            int endPos = a.get(groupStart + groups);
            int valuesToCopy = endPos - startPos;
            ((AbstractRepeatedMapVector)this.to).offsets.clear();
            ((AbstractRepeatedMapVector)this.to).offsets.allocateNew(groups + 1);
            for (int i = 0; i < groups + 1; ++i) {
                int normalizedPos = a.get(groupStart + i) - startPos;
                m3.set(i, normalizedPos);
            }
            m3.setValueCount(groups + 1);
            ((AbstractRepeatedMapVector)this.to).emptyPopulator.populate(groups);
            for (TransferPair p : this.pairs) {
                p.splitAndTransfer(startPos, valuesToCopy);
            }
        }
    }

    public abstract class Mutator
    implements RepeatedValueVector.RepeatedMutator {
        @Override
        public void startNewValue(int index) {
            AbstractRepeatedMapVector.this.emptyPopulator.populate(index + 1);
        }

        @Override
        public void setValueCount(int topLevelValueCount) {
            int childValueCount;
            if (topLevelValueCount == 0) {
                childValueCount = 0;
                AbstractRepeatedMapVector.this.offsets.getMutator().setValueCount(0);
            } else {
                AbstractRepeatedMapVector.this.emptyPopulator.populate(topLevelValueCount);
                childValueCount = AbstractRepeatedMapVector.this.offsets.getAccessor().get(topLevelValueCount);
            }
            for (ValueVector v : AbstractRepeatedMapVector.this.getChildren()) {
                v.getMutator().setValueCount(childValueCount);
            }
        }

        @Override
        public void reset() {
        }

        @Override
        public void generateTestData(int values) {
        }

        public int add(int index) {
            int prevEnd = AbstractRepeatedMapVector.this.offsets.getAccessor().get(index + 1);
            AbstractRepeatedMapVector.this.offsets.getMutator().setSafe(index + 1, prevEnd + 1);
            return prevEnd;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
        }
    }
}

