/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.Var16CharHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.Var16CharVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class Var16CharWriterImpl
extends AbstractFieldWriter {
    private final Var16CharVector.Mutator mutator;
    final Var16CharVector vector;

    public Var16CharWriterImpl(Var16CharVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(Var16CharHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVar16CharHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVar16Char(int start, int end, DrillBuf buffer) {
        this.mutator.setSafe(this.idx(), start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

