/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.UnsupportedFileSystemException;
import oadd.org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import oadd.org.apache.hadoop.fs.viewfs.FsGetter;
import oadd.org.apache.hadoop.fs.viewfs.HCFSMountTableConfigLoader;
import oadd.org.apache.hadoop.fs.viewfs.InodeTree;
import oadd.org.apache.hadoop.fs.viewfs.NotInMountpointException;
import oadd.org.apache.hadoop.fs.viewfs.ViewFileSystem;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "HBase", "Hive"})
@InterfaceStability.Evolving
public class ViewFileSystemOverloadScheme
extends ViewFileSystem {
    private URI myUri;

    @Override
    public String getScheme() {
        return this.myUri.getScheme();
    }

    @Override
    String getType() {
        return "viewfsOverloadScheme";
    }

    @Override
    public void initialize(URI theUri, Configuration conf) throws IOException {
        this.myUri = theUri;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing the ViewFileSystemOverloadScheme with the uri: " + theUri);
        }
        String mountTableConfigPath = conf.get("fs.viewfs.mounttable.path");
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", conf.getBoolean("fs.viewfs.mount.links.as.symlinks", false));
        conf.setBoolean("fs.viewfs.ignore.port.in.mount.table.name", conf.getBoolean("fs.viewfs.ignore.port.in.mount.table.name", true));
        if (null != mountTableConfigPath) {
            HCFSMountTableConfigLoader loader = new HCFSMountTableConfigLoader();
            loader.load(mountTableConfigPath, conf);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Missing configuration for fs.viewfs.mounttable.path. Proceedingwith core-site.xml mount-table information if avaialable.");
        }
        super.initialize(theUri, conf);
    }

    @Override
    protected FsGetter fsGetter() {
        return new ChildFsGetter(this.getScheme());
    }

    public FileSystem getRawFileSystem(Path path, Configuration conf) throws IOException {
        try {
            InodeTree.ResolveResult res = this.fsState.resolve(this.getUriPath(path), true);
            return res.isInternalDir() ? this.fsGetter().get(path.toUri(), conf) : ((ChRootedFileSystem)res.targetFileSystem).getMyFs();
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(path, "No link found for the given path.");
        }
    }

    static class ChildFsGetter
    extends FsGetter {
        private final String rootScheme;

        ChildFsGetter(String rootScheme) {
            this.rootScheme = rootScheme;
        }

        @Override
        public FileSystem getNewInstance(URI uri, Configuration conf) throws IOException {
            if (uri.getScheme().equals(this.rootScheme)) {
                if (FileSystem.LOG.isDebugEnabled()) {
                    FileSystem.LOG.debug("The file system initialized uri scheme is matching with the given target uri scheme. The target uri is: " + uri);
                }
                return this.createFileSystem(uri, conf);
            }
            return FileSystem.newInstance(uri, conf);
        }

        @Override
        public FileSystem get(URI uri, Configuration conf) throws IOException {
            if (uri.getScheme().equals(this.rootScheme)) {
                if (FileSystem.LOG.isDebugEnabled()) {
                    FileSystem.LOG.debug("The file system initialized uri scheme is matching with the given target uri scheme. So, the target file system instances will not be cached. To cache fs instances, please set fs.viewfs.enable.inner.cache to true. The target uri is: " + uri);
                }
                return this.createFileSystem(uri, conf);
            }
            return FileSystem.get(uri, conf);
        }

        private FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
            String fsImplConf = String.format("fs.viewfs.overload.scheme.target.%s.impl", uri.getScheme());
            Class<?> clazz = conf.getClass(fsImplConf, null);
            if (clazz == null) {
                throw new UnsupportedFileSystemException(String.format("%s=null: %s: %s", fsImplConf, "No overload scheme fs configured", uri.getScheme()));
            }
            FileSystem fs = (FileSystem)this.newInstance(clazz, uri, conf);
            fs.initialize(uri, conf);
            return fs;
        }

        private <T> T newInstance(Class<T> theClass, URI uri, Configuration conf) {
            T result;
            try {
                Constructor<T> meth = theClass.getConstructor(new Class[0]);
                meth.setAccessible(true);
                result = meth.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }
    }
}

