/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode;

import oadd.org.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErasureCodeNative {
    private static final Logger LOG = LoggerFactory.getLogger(ErasureCodeNative.class.getName());
    private static final String LOADING_FAILURE_REASON;

    private ErasureCodeNative() {
    }

    public static boolean isNativeCodeLoaded() {
        return LOADING_FAILURE_REASON == null;
    }

    public static void checkNativeCodeLoaded() {
        if (LOADING_FAILURE_REASON != null) {
            throw new RuntimeException(LOADING_FAILURE_REASON);
        }
    }

    public static native void loadLibrary();

    public static native String getLibraryName();

    public static String getLoadingFailureReason() {
        return LOADING_FAILURE_REASON;
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            LOADING_FAILURE_REASON = "hadoop native library cannot be loaded.";
        } else if (!NativeCodeLoader.buildSupportsIsal()) {
            LOADING_FAILURE_REASON = "libhadoop was built without ISA-L support";
        } else {
            String problem = null;
            try {
                ErasureCodeNative.loadLibrary();
            }
            catch (Throwable t) {
                problem = "Loading ISA-L failed: " + t.getMessage();
                LOG.warn(problem);
            }
            LOADING_FAILURE_REASON = problem;
        }
        if (LOADING_FAILURE_REASON != null) {
            LOG.warn("ISA-L support is not available in your platform... using builtin-java codec where applicable");
        }
    }
}

