/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.coder;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.CodecUtil;
import oadd.org.apache.hadoop.io.erasurecode.ECBlock;
import oadd.org.apache.hadoop.io.erasurecode.ECBlockGroup;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureEncodingStep;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class RSErasureEncoder
extends ErasureEncoder {
    private RawErasureEncoder rawEncoder;

    public RSErasureEncoder(ErasureCoderOptions options) {
        super(options);
    }

    @Override
    protected ErasureCodingStep prepareEncodingStep(ECBlockGroup blockGroup) {
        RawErasureEncoder rawEncoder = this.checkCreateRSRawEncoder();
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new ErasureEncodingStep(inputBlocks, this.getOutputBlocks(blockGroup), rawEncoder);
    }

    private RawErasureEncoder checkCreateRSRawEncoder() {
        if (this.rawEncoder == null) {
            this.rawEncoder = CodecUtil.createRawEncoder(this.getConf(), "rs", this.getOptions());
        }
        return this.rawEncoder;
    }

    @Override
    public void release() {
        if (this.rawEncoder != null) {
            this.rawEncoder.release();
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return false;
    }
}

