/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.util.IndexedSortable;
import oadd.org.apache.hadoop.util.IndexedSorter;
import oadd.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HeapSort
implements IndexedSorter {
    private static void downHeap(IndexedSortable s2, int b, int i, int N) {
        int idx = i << 1;
        while (idx < N) {
            if (idx + 1 < N && s2.compare(b + idx, b + idx + 1) < 0) {
                if (s2.compare(b + i, b + idx + 1) >= 0) {
                    return;
                }
                s2.swap(b + i, b + idx + 1);
                i = idx + 1;
            } else if (s2.compare(b + i, b + idx) < 0) {
                s2.swap(b + i, b + idx);
                i = idx;
            } else {
                return;
            }
            idx = i << 1;
        }
    }

    @Override
    public void sort(IndexedSortable s2, int p, int r) {
        this.sort(s2, p, r, null);
    }

    @Override
    public void sort(IndexedSortable s2, int p, int r, Progressable rep) {
        int t;
        int i;
        int N = r - p;
        for (i = t = Integer.highestOneBit(N); i > 1; i >>>= 1) {
            for (int j = i >>> 1; j < i; ++j) {
                HeapSort.downHeap(s2, p - 1, j, N + 1);
            }
            if (null == rep) continue;
            rep.progress();
        }
        for (i = r - 1; i > p; --i) {
            s2.swap(p, i);
            HeapSort.downHeap(s2, p - 1, 1, i - p + 1);
        }
    }
}

