/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.cli;

import java.io.IOException;
import java.util.List;
import oadd.org.apache.commons.cli.CommandLine;
import oadd.org.apache.commons.cli.Option;
import oadd.org.apache.commons.cli.OptionGroup;
import oadd.org.apache.commons.cli.Options;
import oadd.org.apache.commons.cli.ParseException;
import oadd.org.apache.commons.cli.PosixParser;
import oadd.org.apache.zookeeper.CreateMode;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.StatsTrack;
import oadd.org.apache.zookeeper.ZooDefs;
import oadd.org.apache.zookeeper.ZooKeeper;
import oadd.org.apache.zookeeper.cli.CliCommand;
import oadd.org.apache.zookeeper.cli.CliException;
import oadd.org.apache.zookeeper.cli.CliParseException;
import oadd.org.apache.zookeeper.cli.CliWrapperException;
import oadd.org.apache.zookeeper.cli.MalformedCommandException;
import oadd.org.apache.zookeeper.cli.MalformedPathException;
import oadd.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetQuotaCommand
extends CliCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SetQuotaCommand.class);
    private Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetQuotaCommand() {
        super("setquota", "-n|-b val path");
        OptionGroup og1 = new OptionGroup();
        og1.addOption(new Option("b", true, "bytes quota"));
        og1.addOption(new Option("n", true, "num quota"));
        og1.setRequired(true);
        this.options.addOptionGroup(og1);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(this.options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        if (this.cl.hasOption("b")) {
            long bytes = Long.parseLong(this.cl.getOptionValue("b"));
            try {
                SetQuotaCommand.createQuota(this.zk, path, bytes, -1);
            }
            catch (IOException | InterruptedException | KeeperException ex) {
                throw new CliWrapperException(ex);
            }
        } else if (this.cl.hasOption("n")) {
            int numNodes = Integer.parseInt(this.cl.getOptionValue("n"));
            try {
                SetQuotaCommand.createQuota(this.zk, path, -1L, numNodes);
            }
            catch (IOException | InterruptedException | KeeperException ex) {
                throw new CliWrapperException(ex);
            }
        } else {
            throw new MalformedCommandException(this.getUsageStr());
        }
        return false;
    }

    public static boolean createQuota(ZooKeeper zk, String path, long bytes, int numNodes) throws KeeperException, IOException, InterruptedException, MalformedPathException {
        Stat initStat;
        try {
            initStat = zk.exists(path, false);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        if (initStat == null) {
            throw new IllegalArgumentException(path + " does not exist.");
        }
        String quotaPath = "/zookeeper/quota";
        String realPath = "/zookeeper/quota" + path;
        try {
            List<String> children = zk.getChildren(realPath, false);
            for (String child : children) {
                if (child.startsWith("zookeeper_")) continue;
                throw new IllegalArgumentException(path + " has child " + child + " which has a quota");
            }
        }
        catch (KeeperException.NoNodeException children) {
            // empty catch block
        }
        SetQuotaCommand.checkIfParentQuota(zk, path);
        if (zk.exists(quotaPath, false) == null) {
            try {
                zk.create("/zookeeper", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.create("/zookeeper/quota", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException children) {
                // empty catch block
            }
        }
        String[] splits = path.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append(quotaPath);
        for (int i = 1; i < splits.length; ++i) {
            sb.append("/").append(splits[i]);
            quotaPath = sb.toString();
            try {
                zk.create(quotaPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String statPath = quotaPath + "/" + "zookeeper_stats";
        quotaPath = quotaPath + "/" + "zookeeper_limits";
        StatsTrack strack = new StatsTrack(null);
        strack.setBytes(bytes);
        strack.setCount(numNodes);
        try {
            zk.create(quotaPath, strack.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            StatsTrack stats = new StatsTrack(null);
            stats.setBytes(0L);
            stats.setCount(0);
            zk.create(statPath, stats.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ne) {
            byte[] data = zk.getData(quotaPath, false, new Stat());
            StatsTrack strackC = new StatsTrack(new String(data));
            if (bytes != -1L) {
                strackC.setBytes(bytes);
            }
            if (numNodes != -1) {
                strackC.setCount(numNodes);
            }
            zk.setData(quotaPath, strackC.toString().getBytes(), -1);
        }
        return true;
    }

    private static void checkIfParentQuota(ZooKeeper zk, String path) throws InterruptedException, KeeperException {
        String[] splits = path.split("/");
        String quotaPath = "/zookeeper/quota";
        for (String str : splits) {
            if (str.length() == 0) continue;
            quotaPath = quotaPath + "/" + str;
            List<String> children = null;
            try {
                children = zk.getChildren(quotaPath, false);
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.debug("child removed during quota check", ne);
                return;
            }
            if (children.size() == 0) {
                return;
            }
            for (String child : children) {
                if (!"zookeeper_limits".equals(child)) continue;
                throw new IllegalArgumentException(path + " has a parent " + quotaPath + " which has a quota");
            }
        }
    }
}

