/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSocket;
import oadd.org.apache.jute.BinaryInputArchive;
import oadd.org.apache.jute.BinaryOutputArchive;
import oadd.org.apache.jute.InputArchive;
import oadd.org.apache.jute.OutputArchive;
import oadd.org.apache.jute.Record;
import oadd.org.apache.zookeeper.common.X509Exception;
import oadd.org.apache.zookeeper.server.Request;
import oadd.org.apache.zookeeper.server.ServerCnxn;
import oadd.org.apache.zookeeper.server.ZooTrace;
import oadd.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import oadd.org.apache.zookeeper.server.quorum.LearnerHandler;
import oadd.org.apache.zookeeper.server.quorum.LearnerInfo;
import oadd.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import oadd.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import oadd.org.apache.zookeeper.server.quorum.QuorumPacket;
import oadd.org.apache.zookeeper.server.quorum.QuorumPeer;
import oadd.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import oadd.org.apache.zookeeper.server.quorum.Vote;
import oadd.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import oadd.org.apache.zookeeper.server.util.SerializeUtils;
import oadd.org.apache.zookeeper.server.util.ZxidUtils;
import oadd.org.apache.zookeeper.txn.SetDataTxn;
import oadd.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Learner {
    QuorumPeer self;
    LearnerZooKeeperServer zk;
    protected BufferedOutputStream bufferedOutput;
    protected Socket sock;
    protected InputArchive leaderIs;
    protected OutputArchive leaderOs;
    protected int leaderProtocolVersion = 1;
    protected static final Logger LOG = LoggerFactory.getLogger(Learner.class);
    private static final boolean nodelay = System.getProperty("follower.nodelay", "true").equals("true");
    final ConcurrentHashMap<Long, ServerCnxn> pendingRevalidations = new ConcurrentHashMap();

    public Socket getSocket() {
        return this.sock;
    }

    public int getPendingRevalidationsCount() {
        return this.pendingRevalidations.size();
    }

    void validateSession(ServerCnxn cnxn, long clientId, int timeout) throws IOException {
        LOG.info("Revalidating client: 0x" + Long.toHexString(clientId));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(clientId);
        dos.writeInt(timeout);
        dos.close();
        QuorumPacket qp = new QuorumPacket(6, -1L, baos.toByteArray(), null);
        this.pendingRevalidations.put(clientId, cnxn);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "To validate session 0x" + Long.toHexString(clientId));
        }
        this.writePacket(qp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePacket(QuorumPacket pp, boolean flush) throws IOException {
        OutputArchive outputArchive = this.leaderOs;
        synchronized (outputArchive) {
            if (pp != null) {
                this.leaderOs.writeRecord(pp, "packet");
            }
            if (flush) {
                this.bufferedOutput.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPacket(QuorumPacket pp) throws IOException {
        InputArchive inputArchive = this.leaderIs;
        synchronized (inputArchive) {
            this.leaderIs.readRecord(pp, "packet");
        }
        if (LOG.isTraceEnabled()) {
            long traceMask = pp.getType() == 5 ? 128L : 16L;
            ZooTrace.logQuorumPacket(LOG, traceMask, 'i', pp);
        }
    }

    void request(Request request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream oa = new DataOutputStream(baos);
        oa.writeLong(request.sessionId);
        oa.writeInt(request.cxid);
        oa.writeInt(request.type);
        if (request.request != null) {
            request.request.rewind();
            int len = request.request.remaining();
            byte[] b = new byte[len];
            request.request.get(b);
            request.request.rewind();
            oa.write(b);
        }
        oa.close();
        QuorumPacket qp = new QuorumPacket(1, -1L, baos.toByteArray(), request.authInfo);
        this.writePacket(qp, true);
    }

    protected QuorumPeer.QuorumServer findLeader() {
        QuorumPeer.QuorumServer leaderServer = null;
        Vote current = this.self.getCurrentVote();
        for (QuorumPeer.QuorumServer s2 : this.self.getView().values()) {
            if (s2.id != current.getId()) continue;
            s2.recreateSocketAddresses();
            leaderServer = s2;
            break;
        }
        if (leaderServer == null) {
            LOG.warn("Couldn't find the leader with id = " + current.getId());
        }
        return leaderServer;
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    protected void sockConnect(Socket sock, InetSocketAddress addr, int timeout) throws IOException {
        sock.connect(addr, timeout);
    }

    protected void connectToLeader(InetSocketAddress addr, String hostname) throws IOException, InterruptedException, X509Exception {
        int initLimitTime;
        this.sock = this.createSocket();
        int remainingInitLimitTime = initLimitTime = this.self.tickTime * this.self.initLimit;
        long startNanoTime = this.nanoTime();
        for (int tries = 0; tries < 5; ++tries) {
            try {
                remainingInitLimitTime = initLimitTime - (int)((this.nanoTime() - startNanoTime) / 1000000L);
                if (remainingInitLimitTime <= 0) {
                    LOG.error("initLimit exceeded on retries.");
                    throw new IOException("initLimit exceeded on retries.");
                }
                this.sockConnect(this.sock, addr, Math.min(this.self.tickTime * this.self.syncLimit, remainingInitLimitTime));
                if (this.self.isSslQuorum()) {
                    ((SSLSocket)this.sock).startHandshake();
                }
                this.sock.setTcpNoDelay(nodelay);
                break;
            }
            catch (IOException e) {
                remainingInitLimitTime = initLimitTime - (int)((this.nanoTime() - startNanoTime) / 1000000L);
                if (remainingInitLimitTime <= 1000) {
                    LOG.error("Unexpected exception, initLimit exceeded. tries=" + tries + ", remaining init limit=" + remainingInitLimitTime + ", connecting to " + addr, e);
                    throw e;
                }
                if (tries >= 4) {
                    LOG.error("Unexpected exception, retries exceeded. tries=" + tries + ", remaining init limit=" + remainingInitLimitTime + ", connecting to " + addr, e);
                    throw e;
                }
                LOG.warn("Unexpected exception, tries=" + tries + ", remaining init limit=" + remainingInitLimitTime + ", connecting to " + addr, e);
                this.sock = this.createSocket();
                Thread.sleep(1000L);
                continue;
            }
        }
        this.self.authLearner.authenticate(this.sock, hostname);
        this.leaderIs = BinaryInputArchive.getArchive(new BufferedInputStream(this.sock.getInputStream()));
        this.bufferedOutput = new BufferedOutputStream(this.sock.getOutputStream());
        this.leaderOs = BinaryOutputArchive.getArchive(this.bufferedOutput);
    }

    private Socket createSocket() throws X509Exception, IOException {
        Socket sock = this.self.isSslQuorum() ? this.self.getX509Util().createSSLSocket() : new Socket();
        sock.setSoTimeout(this.self.tickTime * this.self.initLimit);
        return sock;
    }

    protected long registerWithLeader(int pktType) throws IOException {
        long lastLoggedZxid = this.self.getLastLoggedZxid();
        QuorumPacket qp = new QuorumPacket();
        qp.setType(pktType);
        qp.setZxid(ZxidUtils.makeZxid(this.self.getAcceptedEpoch(), 0L));
        LearnerInfo li = new LearnerInfo(this.self.getId(), 65536, this.self.getQuorumVerifier().getVersion());
        ByteArrayOutputStream bsid = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(bsid);
        boa.writeRecord(li, "LearnerInfo");
        qp.setData(bsid.toByteArray());
        this.writePacket(qp, true);
        this.readPacket(qp);
        long newEpoch = ZxidUtils.getEpochFromZxid(qp.getZxid());
        if (qp.getType() == 17) {
            this.leaderProtocolVersion = ByteBuffer.wrap(qp.getData()).getInt();
            byte[] epochBytes = new byte[4];
            ByteBuffer wrappedEpochBytes = ByteBuffer.wrap(epochBytes);
            if (newEpoch > this.self.getAcceptedEpoch()) {
                wrappedEpochBytes.putInt((int)this.self.getCurrentEpoch());
                this.self.setAcceptedEpoch(newEpoch);
            } else if (newEpoch == this.self.getAcceptedEpoch()) {
                wrappedEpochBytes.putInt(-1);
            } else {
                throw new IOException("Leaders epoch, " + newEpoch + " is less than accepted epoch, " + this.self.getAcceptedEpoch());
            }
            QuorumPacket ackNewEpoch = new QuorumPacket(18, lastLoggedZxid, epochBytes, null);
            this.writePacket(ackNewEpoch, true);
            return ZxidUtils.makeZxid(newEpoch, 0L);
        }
        if (newEpoch > this.self.getAcceptedEpoch()) {
            this.self.setAcceptedEpoch(newEpoch);
        }
        if (qp.getType() != 10) {
            LOG.error("First packet should have been NEWLEADER");
            throw new IOException("First packet should have been NEWLEADER");
        }
        return qp.getZxid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncWithLeader(long newLeaderZxid) throws Exception {
        QuorumPacket ack = new QuorumPacket(3, 0L, null, null);
        QuorumPacket qp = new QuorumPacket();
        long newEpoch = ZxidUtils.getEpochFromZxid(newLeaderZxid);
        QuorumVerifier newLeaderQV = null;
        boolean snapshotNeeded = true;
        this.readPacket(qp);
        LinkedList<Long> packetsCommitted = new LinkedList<Long>();
        LinkedList<PacketInFlight> packetsNotCommitted = new LinkedList<PacketInFlight>();
        LearnerZooKeeperServer learnerZooKeeperServer = this.zk;
        synchronized (learnerZooKeeperServer) {
            boolean writeToTxnLog;
            if (qp.getType() == 13) {
                LOG.info("Getting a diff from the leader 0x{}", (Object)Long.toHexString(qp.getZxid()));
                snapshotNeeded = false;
            } else if (qp.getType() == 15) {
                String signature;
                LOG.info("Getting a snapshot from leader 0x" + Long.toHexString(qp.getZxid()));
                this.zk.getZKDatabase().deserializeSnapshot(this.leaderIs);
                if (!QuorumPeerConfig.isReconfigEnabled()) {
                    LOG.debug("Reset config node content from local config after deserialization of snapshot.");
                    this.zk.getZKDatabase().initConfigInZKDatabase(this.self.getQuorumVerifier());
                }
                if (!(signature = this.leaderIs.readString("signature")).equals("BenWasHere")) {
                    LOG.error("Missing signature. Got " + signature);
                    throw new IOException("Missing signature");
                }
                this.zk.getZKDatabase().setlastProcessedZxid(qp.getZxid());
            } else if (qp.getType() == 14) {
                LOG.warn("Truncating log to get in sync with the leader 0x" + Long.toHexString(qp.getZxid()));
                boolean truncated = this.zk.getZKDatabase().truncateLog(qp.getZxid());
                if (!truncated) {
                    LOG.error("Not able to truncate the log " + Long.toHexString(qp.getZxid()));
                    System.exit(13);
                }
                this.zk.getZKDatabase().setlastProcessedZxid(qp.getZxid());
            } else {
                LOG.error("Got unexpected packet from leader: {}, exiting ... ", (Object)LearnerHandler.packetToString(qp));
                System.exit(13);
            }
            this.zk.getZKDatabase().initConfigInZKDatabase(this.self.getQuorumVerifier());
            this.zk.createSessionTracker();
            long lastQueued = 0L;
            boolean isPreZAB1_0 = true;
            boolean bl = writeToTxnLog = !snapshotNeeded;
            block11: while (this.self.isRunning()) {
                this.readPacket(qp);
                switch (qp.getType()) {
                    case 2: {
                        QuorumVerifier qv;
                        PacketInFlight pif = new PacketInFlight();
                        pif.hdr = new TxnHeader();
                        pif.rec = SerializeUtils.deserializeTxn(qp.getData(), pif.hdr);
                        if (pif.hdr.getZxid() != lastQueued + 1L) {
                            LOG.warn("Got zxid 0x" + Long.toHexString(pif.hdr.getZxid()) + " expected 0x" + Long.toHexString(lastQueued + 1L));
                        }
                        lastQueued = pif.hdr.getZxid();
                        if (pif.hdr.getType() == 16) {
                            SetDataTxn setDataTxn = (SetDataTxn)pif.rec;
                            qv = this.self.configFromString(new String(setDataTxn.getData()));
                            this.self.setLastSeenQuorumVerifier(qv, true);
                        }
                        packetsNotCommitted.add(pif);
                        break;
                    }
                    case 4: 
                    case 9: {
                        QuorumVerifier qv;
                        boolean majorChange;
                        PacketInFlight pif = (PacketInFlight)packetsNotCommitted.peekFirst();
                        if (pif.hdr.getZxid() == qp.getZxid() && qp.getType() == 9 && (majorChange = this.self.processReconfig(qv = this.self.configFromString(new String(((SetDataTxn)pif.rec).getData())), ByteBuffer.wrap(qp.getData()).getLong(), qp.getZxid(), true))) {
                            throw new Exception("changes proposed in reconfig");
                        }
                        if (!writeToTxnLog) {
                            if (pif.hdr.getZxid() != qp.getZxid()) {
                                LOG.warn("Committing " + qp.getZxid() + ", but next proposal is " + pif.hdr.getZxid());
                                break;
                            }
                            this.zk.processTxn(pif.hdr, pif.rec);
                            packetsNotCommitted.remove();
                            break;
                        }
                        packetsCommitted.add(qp.getZxid());
                        break;
                    }
                    case 8: 
                    case 19: {
                        PacketInFlight packet = new PacketInFlight();
                        packet.hdr = new TxnHeader();
                        if (qp.getType() == 19) {
                            ByteBuffer buffer = ByteBuffer.wrap(qp.getData());
                            long suggestedLeaderId = buffer.getLong();
                            byte[] remainingdata = new byte[buffer.remaining()];
                            buffer.get(remainingdata);
                            packet.rec = SerializeUtils.deserializeTxn(remainingdata, packet.hdr);
                            QuorumVerifier qv = this.self.configFromString(new String(((SetDataTxn)packet.rec).getData()));
                            boolean majorChange = this.self.processReconfig(qv, suggestedLeaderId, qp.getZxid(), true);
                            if (majorChange) {
                                throw new Exception("changes proposed in reconfig");
                            }
                        } else {
                            packet.rec = SerializeUtils.deserializeTxn(qp.getData(), packet.hdr);
                            if (packet.hdr.getZxid() != lastQueued + 1L) {
                                LOG.warn("Got zxid 0x" + Long.toHexString(packet.hdr.getZxid()) + " expected 0x" + Long.toHexString(lastQueued + 1L));
                            }
                            lastQueued = packet.hdr.getZxid();
                        }
                        if (!writeToTxnLog) {
                            this.zk.processTxn(packet.hdr, packet.rec);
                            break;
                        }
                        packetsNotCommitted.add(packet);
                        packetsCommitted.add(qp.getZxid());
                        break;
                    }
                    case 12: {
                        boolean majorChange;
                        LOG.info("Learner received UPTODATE message");
                        if (newLeaderQV != null && (majorChange = this.self.processReconfig(newLeaderQV, null, null, true))) {
                            throw new Exception("changes proposed in reconfig");
                        }
                        if (isPreZAB1_0) {
                            this.zk.takeSnapshot();
                            this.self.setCurrentEpoch(newEpoch);
                        }
                        this.self.setZooKeeperServer(this.zk);
                        this.self.adminServer.setZooKeeperServer(this.zk);
                        break block11;
                    }
                    case 10: {
                        QuorumVerifier qv;
                        LOG.info("Learner received NEWLEADER message");
                        if (qp.getData() != null && qp.getData().length > 1) {
                            try {
                                qv = this.self.configFromString(new String(qp.getData()));
                                this.self.setLastSeenQuorumVerifier(qv, true);
                                newLeaderQV = qv;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (snapshotNeeded) {
                            this.zk.takeSnapshot();
                        }
                        this.self.setCurrentEpoch(newEpoch);
                        writeToTxnLog = true;
                        isPreZAB1_0 = false;
                        this.writePacket(new QuorumPacket(3, newLeaderZxid, null, null), true);
                    }
                }
            }
        }
        ack.setZxid(ZxidUtils.makeZxid(newEpoch, 0L));
        this.writePacket(ack, true);
        this.sock.setSoTimeout(this.self.tickTime * this.self.syncLimit);
        this.zk.startup();
        this.self.updateElectionVote(newEpoch);
        if (this.zk instanceof FollowerZooKeeperServer) {
            FollowerZooKeeperServer fzk = (FollowerZooKeeperServer)this.zk;
            for (PacketInFlight p : packetsNotCommitted) {
                fzk.logRequest(p.hdr, p.rec);
            }
            for (Long zxid : packetsCommitted) {
                fzk.commit(zxid);
            }
            return;
        } else {
            if (!(this.zk instanceof ObserverZooKeeperServer)) {
                throw new UnsupportedOperationException("Unknown server type");
            }
            ObserverZooKeeperServer ozk = (ObserverZooKeeperServer)this.zk;
            for (PacketInFlight p : packetsNotCommitted) {
                Long zxid = (Long)packetsCommitted.peekFirst();
                if (p.hdr.getZxid() != zxid.longValue()) {
                    LOG.warn("Committing " + Long.toHexString(zxid) + ", but next proposal is " + Long.toHexString(p.hdr.getZxid()));
                    continue;
                }
                packetsCommitted.remove();
                Request request = new Request(null, p.hdr.getClientId(), p.hdr.getCxid(), p.hdr.getType(), null, null);
                request.setTxn(p.rec);
                request.setHdr(p.hdr);
                ozk.commitRequest(request);
            }
        }
    }

    protected void revalidate(QuorumPacket qp) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
        DataInputStream dis = new DataInputStream(bis);
        long sessionId = dis.readLong();
        boolean valid = dis.readBoolean();
        ServerCnxn cnxn = this.pendingRevalidations.remove(sessionId);
        if (cnxn == null) {
            LOG.warn("Missing session 0x" + Long.toHexString(sessionId) + " for validation");
        } else {
            this.zk.finishSessionInit(cnxn, valid);
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + valid);
        }
    }

    protected void ping(QuorumPacket qp) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Map<Long, Integer> touchTable = this.zk.getTouchSnapshot();
        for (Map.Entry<Long, Integer> entry : touchTable.entrySet()) {
            dos.writeLong(entry.getKey());
            dos.writeInt(entry.getValue());
        }
        qp.setData(bos.toByteArray());
        this.writePacket(qp, true);
    }

    public void shutdown() {
        this.self.setZooKeeperServer(null);
        this.self.closeAllConnections();
        this.self.adminServer.setZooKeeperServer(null);
        if (this.zk != null) {
            this.zk.shutdown();
        }
    }

    boolean isRunning() {
        return this.self.isRunning() && this.zk.isRunning();
    }

    static {
        LOG.info("TCP NoDelay set to: " + nodelay);
    }

    static class PacketInFlight {
        TxnHeader hdr;
        Record rec;

        PacketInFlight() {
        }
    }
}

