/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.DriverVersion;
import oadd.org.apache.calcite.avatica.Handler;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.UnregisteredDriver;
import oadd.org.apache.drill.common.util.DrillVersionInfo;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillHandler;
import org.apache.drill.jdbc.impl.DrillMetaImpl;

public class DriverImpl
extends UnregisteredDriver {
    private static final String CONNECTION_STRING_PREFIX = "jdbc:drill:";
    private static final String METADATA_PROPERTIES_RESOURCE_PATH = "apache-drill-jdbc.properties";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECTION_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "org.apache.drill.jdbc.impl.DrillJdbc3Factory";
            }
            case JDBC_40: {
                return "org.apache.drill.jdbc.impl.DrillJdbc40Factory";
            }
        }
        return "org.apache.drill.jdbc.impl.DrillJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(this.getClass(), METADATA_PROPERTIES_RESOURCE_PATH, "Apache Drill JDBC Driver", DrillVersionInfo.getVersion(), "Apache Drill", "<Properties resource apache-drill-jdbc.properties not loaded>");
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new DrillMetaImpl((DrillConnectionImpl)connection);
    }

    @Override
    protected Handler createHandler() {
        return new DrillHandler();
    }
}

